#ifndef __CAMERA_H__
#define __CAMERA_H__

#include "../optic.h"
#include "../core/entity.h"
#include "../renderer/renderer.h"
#include "../input/input.h"

class Camera : public Entity {
public:

	Camera(Renderer*, InputManager*);

	virtual void enable();
	
	virtual void lookat(const Vector&, const Vector&, const Vector&);
	virtual void setViewPoint(const Vector&);
	virtual Vector getEyePoint();
	virtual void moveOnView(op_float);

	//Lock to Mouse/Joy/Trackball device
	virtual void lockToTrackball(op_inphnd);
	virtual void updateTrackball();
	virtual bool isLockedTrackball();
	//Follow Spline
	//Rotate around owner of camera
	//Render?
	//In other words much better than the raw ORS Transformer

	virtual bool QueryInterface(const EntityType, void**);

protected:

	void rotate_view(op_float,Vector&);

	Renderer* m_rend;
	InputManager* m_input;
	Vector m_at,m_eye,m_up;
	op_inphnd m_mouse;
	bool m_tracklock;
};

#endif