#include "aaboundingbox.h"

AABoundingBox::AABoundingBox() {

}

AABoundingBox::AABoundingBox(const Vector& loc, const Vector& len) : m_location(loc), m_extents(len) {

}

bool AABoundingBox::intersects(const AABoundingBox& box) {

	return false;
}

bool AABoundingBox::intersects(const Vector& v1,const Vector& v2,const Vector& v3) {

	int i;
	Vector tri[3];

	tri[0] = v1;
	tri[1] = v2;
	tri[2] = v3;

	for (i = 0; i < 3; i++) {

		if (tri[i][0] > m_location[0]+m_extents[0] || tri[i][0] < m_location[0]-m_extents[0])
			continue;

		if (tri[i][1] > m_location[1]+m_extents[1] || tri[i][1] < m_location[1]-m_extents[1])
			continue;

		if (tri[i][2] > m_location[2]+m_extents[2] || tri[i][2] < m_location[2]-m_extents[2])
			continue;

		return true;
	}

	return false;
}

Vector AABoundingBox::getLocation() {
	return m_location;
}

Vector AABoundingBox::getExtents() {
	return m_extents;
}

void AABoundingBox::setExtents(const Vector& len) {
	m_extents = len;
}

void AABoundingBox::setLocation(const Vector& loc) {
	m_location = loc;
}