#ifndef __3DSMESH_H__
#define __3DSMESH_H__

#define MESH_3DS_PRIMARY					0x4D4D

#define MESH_3DS_OBJECTINFO					0x3D3D			
#define MESH_3DS_VERSION					0x0002			
#define MESH_3DS_EDITKEYFRAME				0xB000	

#define MESH_3DS_MATERIAL					0xAFFF				
#define MESH_3DS_OBJECT						0x4000				

#define MESH_3DS_MATNAME					0xA000				
#define MESH_3DS_MATDIFFUSE					0xA020				
#define MESH_3DS_MATMAP						0xA200				
#define MESH_3DS_MATMAPFILE					0xA300				

#define MESH_3DS_OBJECT_MESH				0x4100			

#define MESH_3DS_OBJECT_VERTICES			0x4110		
#define MESH_3DS_OBJECT_FACES				0x4120		
#define MESH_3DS_OBJECT_MATERIAL			0x4130			
#define MESH_3DS_OBJECT_UV					0x4140		

#define MESH_3DS_MAX_TEXTURES				100							

typedef struct {
	float x, y;
} tVector2;

typedef struct {
	float x, y, z;
} tVector3;

typedef struct {
	int vertIndex[3];		
	int coordIndex[3];		
} tFace;

typedef struct {
	char strName[255];		
	char strFile[255];		
	BYTE color[3];			
	int textureId;			
	float uTile;			
	float vTile;				
	float uOffset;			   
	float vOffset;			
} tMaterialInfo;

typedef struct {	
	int numOfVerts;			
	int numOfFaces;			
	int numTexVertex;		
	int materialID;			
	bool bHasTexture;			
	char strName[255];			

	UINT *pIndices;	
	tVector3 *pVerts;			
	tVector3 *pNormals;		
	tVector2 *pTexVerts;	
	tFace *pFaces;	
} t3DObject;

typedef struct {
	int numOfObjects;				
	int numOfMaterials;				
	vector<tMaterialInfo> pMaterials;
	vector<t3DObject> pObject;		
} t3DModel;

typedef struct {							
	unsigned short a, b, c, bVisible;		
} tIndices ;

typedef struct {
	unsigned short int ID;							
	unsigned int length;				
	unsigned int bytesRead;				
} tChunk;

#endif