#ifndef __CUBEMAPDEMO_H__
#define __CUBEMAPDEMO_H__

#include "optic.h"
#include "renderer/renderer.h"
#include "core/demo.h"
#include "graphics/skybox.h"
#include "graphics/mesh.h"

#define SIN_PERIOD	3.079f

class CubeMapDemo : public Demo {
public:

	CubeMapDemo();

	virtual void init();

	virtual void update(op_float);
	virtual void render();

	virtual string getName();

private:

	void render_scene();
	void render_blur();

	Renderer* m_rend;

	Texture* m_textures[9],*m_rtexture;
	SkyBox* m_skybox;
	Primitive* m_pquad;
	Mesh* m_cube,*m_sphere,*m_torus;
	Fog* m_fog;
	Font* m_font;
	VertexShader* m_shader;

	op_float m_anim,m_freq,m_amp; // Ripple
	op_float m_xpos,m_xrot,m_inc;
	op_rect m_viewport;
	int m_mark;
	Vector m_svel[3],m_spos[3];
};

#endif
