#include "cubemapdemo.h"

CubeMapDemo::CubeMapDemo() : m_freq(10.0f), m_amp(0.065f), m_anim(0) {
	
	m_xpos = 0;
	m_xrot = 0;
	m_inc = 25.0f;

	m_spos[0] = Vector(0,10,-20);
	m_svel[0] = Vector(10,8,13);

	m_spos[1] = Vector(10,5,-10);
	m_svel[1] = Vector(-5,-15,5);

	m_spos[2] = Vector(0,10,-15);
//	m_svel[2] = Vector(10,-5,-5);

	m_custrender = true;
}

void CubeMapDemo::init() {

	Vertex tvert;
	op_rect vp;
	BuildParameters* bps[2];
	
	Demo::init();

	m_rend = (Renderer*) g_engine->getSubSystem(OPTIC_SUBSYS_RENDERER);
	//m_rend->setFillMode(RND_MODE_WIREFRAME);
	
	m_viewport = m_rend->getWindow()->getViewer()->getViewport();
	m_entman->getGeometry()->getViewer()->getCamera()->lookat(Vector(0,20,30),Vector(0,15,0),Vector(0,1,0));
	
	m_textures[0] = m_dman->create2DMipmap("miors.tga");
	m_textures[1] = m_dman->create2DMipmap("CloudyHills_0.tga");
	m_textures[2] = m_dman->create2DMipmap("CloudyHills_1.tga");
	m_textures[3] = m_dman->create2DMipmap("CloudyHills_2.tga");
	m_textures[4] = m_dman->create2DMipmap("CloudyHills_3.tga");
	m_textures[5] = m_dman->create2DMipmap("CloudyHills_4.tga");
	m_textures[6] = m_dman->create2DMipmap("CloudyHills_5.tga");
	m_textures[7] = m_dman->createCubeMap("c:/optic/data/textures/cubemap/CloudyHillstga");
	m_textures[8] = m_dman->create2DMipmap("miors_inv.tga");
	m_rtexture = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	m_rtexture->create(NULL,TEXTURE_TYPE_RENDER);
	m_textures[3]->setCombineMode(TEXTURE_COMBINE_DECAL);
	m_textures[1]->setCombineMode(TEXTURE_COMBINE_DECAL);
	m_textures[2]->setCombineMode(TEXTURE_COMBINE_DECAL);

	m_pquad = (Primitive*) m_rend->newObject(RND_OBJECT_PRIMITIVE);
	m_pquad->setType(PRIM_QUAD);
	vp = m_rend->getWindow()->getViewer()->getViewport();
	tvert.m_position = Vector(0,0,0);
	tvert.m_texcoords.push_back(Vector(0,1,0));
	m_pquad->addVertex(tvert); tvert.m_texcoords.pop_back();
	tvert.m_position = Vector(0,vp.height,0);
	tvert.m_texcoords.push_back(Vector(0,0,0));
	m_pquad->addVertex(tvert); tvert.m_texcoords.pop_back();
	tvert.m_position = Vector(vp.width,vp.height,0);
	tvert.m_texcoords.push_back(Vector(1,0,0));
	m_pquad->addVertex(tvert); tvert.m_texcoords.pop_back();
	tvert.m_position = Vector(vp.width,0,0);
	tvert.m_texcoords.push_back(Vector(1,1,0));
	m_pquad->addVertex(tvert); tvert.m_texcoords.pop_back();
	m_pquad->getMaterial()->addTexture(m_rtexture);
	m_pquad->getMaterial()->setDiffuse(Triple(1,1,1));
	m_pquad->getMaterial()->setOpacity(0.92f);
	
	m_fog = (Fog*) m_rend->newObject(RND_OBJECT_FOG);
	m_fog->setDensity(0.01f);
//	m_fog->enable();
	
	m_cube = (Mesh*) m_entman->create("cube");
	m_cube->getMaterial()->addTexture(m_textures[0]);
	m_cube->getMaterial()->addTexture(m_textures[7]);
	m_cube->getOrientation()->scale(Vector(5,5,5));
	m_cube->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_CUBEMAPONLY));

	m_torus = (Mesh*) m_entman->create("torus");
	m_torus->getMaterial()->addTexture(m_textures[0]);
	m_torus->getMaterial()->addTexture(m_textures[7]);
	m_torus->getOrientation()->scale(Vector(5,5,5));
	m_torus->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_CUBEMAPONLY));	

	m_sphere = (Mesh*) m_entman->create("sphere");
	m_sphere->getMaterial()->addTexture(m_textures[8]);
	m_sphere->getMaterial()->addTexture(m_textures[7]);
	m_sphere->getOrientation()->scale(Vector(5,5,5));
	m_sphere->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_CUBEMAPONLY));

	bps[1] = new SkyBoxBuildParameters();
	((SkyBoxBuildParameters*)bps[1])->height = 40;
	((SkyBoxBuildParameters*)bps[1])->width = 40;
	((SkyBoxBuildParameters*)bps[1])->depth = 45;
	m_skybox = (SkyBox*) m_entman->create("skybox",false);
	m_skybox->getMaterial()->addTexture(m_textures[1]);
	m_skybox->getMaterial()->addTexture(m_textures[2]);
	m_skybox->getMaterial()->addTexture(m_textures[3]);
	m_skybox->getMaterial()->addTexture(m_textures[4]);
	m_skybox->getMaterial()->addTexture(m_textures[5]);
	m_skybox->getMaterial()->addTexture(m_textures[6]);
	m_skybox->build(bps[1]);
	
	m_font = (Font*) m_rend->newObject(RND_OBJECT_FONT);
	m_font->create("Times New Roman",14,FONT_STYLE_BOLD,Triple(1,0,1),m_rend->getWindow());

	m_mark = m_timer->mark();

	m_shader = (VertexShader*) m_rend->newObject(RND_OBJECT_VTXSHADER);
	m_shader->load(g_configman->getFile("ripple.vsd").c_str());
	m_shader->setConstant(20,Vector(0,0,10));
	m_shader->setConstant(21,Vector(0.2f,0.2f,0.2f,0.0f));
	m_shader->setConstant(22,Vector(0,0,0,0));
	m_shader->setConstant(23,Vector(0,20,30,1));
	m_shader->setConstant(62,Vector(1.0f/(2.0f*SIN_PERIOD),2.0f*SIN_PERIOD,SIN_PERIOD,SIN_PERIOD/2.0f));
	m_shader->setConstant(63,Vector(1.0f,1.0f/(3*2),1.0f/(5*4*3*2),1.0f/(7*6*5*4*3*2)));
	m_shader->setConstant(60,Vector(m_anim,0,0));
	m_shader->setConstant(61,Vector(m_freq,m_amp,0));

//	m_torus->setVertexShader(m_shader);
}

void CubeMapDemo::update(op_float dt) {

	int i;

	for (i = 0; i < 3; i++) {
		m_spos[i] += m_svel[i]*dt;
		
		if (m_spos[i][2] < -40) {
			m_spos[i][2] = -40;
			m_svel[i][2] = -m_svel[i][2];
		}
		else if (m_spos[i][2] > 0) {
			m_spos[i][2] = 0;
			m_svel[i][2] = -m_svel[i][2];
		}
		
		if (m_spos[i][1] < 0) {
			m_spos[i][1] = 0;
			m_svel[i][1] = -m_svel[i][1];
		}
		else if (m_spos[i][1] > 20) {
			m_spos[i][1] = 20;
			m_svel[i][1] = -m_svel[i][1];
		}
		
		if (m_spos[i][0] < -20) {
			m_spos[i][0] = -20;
			m_svel[i][0] = -m_svel[i][0];
		}
		else if (m_spos[i][0] > 20) {
			m_spos[i][0] = 20;
			m_svel[i][0] = -m_svel[i][0];
		}
		
	}

	m_anim -= 5.0f*dt;
	m_xrot += m_inc*dt;

	m_cube->getOrientation()->translate(m_spos[1]);
	m_cube->getOrientation()->rotate_euler(m_xrot,-m_xrot,0);
	m_sphere->getOrientation()->translate(m_spos[0]);
	m_sphere->getOrientation()->rotate_euler(m_xrot,-m_xrot,0);
	m_torus->getOrientation()->translate(m_spos[2]);
	m_torus->getOrientation()->rotate_euler(m_xrot,-m_xrot,0);

	m_shader->setConstant(23,m_entman->getGeometry()->getViewer()->getCamera()->getEyePoint());
	m_shader->setConstant(60,Vector(m_anim,0,0));
}

void CubeMapDemo::render() {

	m_rend->clearBuffers();

	if (m_timer->markTime(m_mark) > 0.01f) {
		
		m_rend->redirectTexture(m_rtexture);
		render_blur();
		m_entman->getGeometry()->render(false);
		m_rend->commitTexture(true,m_rtexture);

		m_timer->unmark(m_mark);
		m_mark = m_timer->mark();
	}

	m_skybox->render();
	render_blur();
	m_entman->getGeometry()->render(false);

	m_rend->text(10,10,m_font,"FPS: %.1f",m_timer->getFPS());
	m_rend->text(10,20,m_font,"Cube Map Reflection Mapping");
	m_rend->text(10,30,m_font,"w/ Ripple Vertex Shader on Torus");
}

void CubeMapDemo::render_blur() {

	m_rend->getCamera()->push();
	m_rend->getCamera()->identity();

	m_rend->setZBuffer(false,RND_DEFAULT);							
	m_rend->setBlender(true, RND_BLEND_SRCALPHA, RND_BLEND_ONE);		
	
	m_rend->getWindow()->getViewer()->ortho(0,m_viewport.width,m_viewport.height,0,0,1);

	m_rend->render(m_pquad);
	
	m_rend->getWindow()->getViewer()->perspective(m_rend->getWindow()->getLastFrustum());
	
	m_rend->setZBuffer(true,RND_DEFAULT);						
	m_rend->setBlender(false,0,0);							
	
	m_rend->getCamera()->pop();
}

void CubeMapDemo::render_scene() {
	
	m_rend->getCamera()->push();
	m_rend->getCamera()->identity();

	m_rend->getCamera()->lookat(Vector(0,-20,30),Vector(-10,-20,0),Vector(0,1,0));
	m_rend->getCamera()->rotate(TRANS_AXIS_Y,m_xrot);

	m_skybox->render();

	m_rend->getCamera()->pop();
	
}

string CubeMapDemo::getName() {
	
	return "Cube Map Reflection Demo";
}