#include "cube.h"

Cube::Cube() {

	int i;
	for (i = 0; i < 6; i++)
		m_faces[i]=NULL;

	m_facemat = NULL;
}

Cube::~Cube() {
	
}

void Cube::destroy() {
	
	int i;

	if (m_facemat != NULL) {
		delete m_facemat;
		m_facemat = NULL;
	}
	
	for (i = 0; i < 6; i++) {
		if (m_faces[i] != NULL) {
			delete [] m_faces[i];
			m_faces[i]=NULL;
		}
	}
	
}

void Cube::build(op_float side) {
	
	Renderer* rend = (Renderer*) g_engine->getSubSystem(OPTIC_SUBSYS_RENDERER);
	op_float half_side;
	Vertex v;
	int i;
	
	half_side = side * 0.5f;
	
	destroy();
	m_facemat = (Material*) rend->newObject(RND_OBJECT_MATERIAL);
	for (i = 0; i < m_textures.size(); i++)
		m_facemat->addTexture(m_textures[i]);

	// Front Face
	v.m_normal = Vector(0,0,1);
	m_faces[0] = (Primitive*) rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[0]->setType(PRIM_QUAD);
	v.m_position = Vector(-half_side,-half_side,half_side);
	v.m_texcoords.push_back(Vector(0,0,0)); 
	m_faces[0]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,-half_side,half_side);
	v.m_texcoords.push_back(Vector(1,0,0));
	m_faces[0]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,half_side,half_side);
	v.m_texcoords.push_back(Vector(1,1,0)); 
	m_faces[0]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,half_side,half_side);
	v.m_texcoords.push_back(Vector(0,1,0));
	m_faces[0]->addVertex(v); v.m_texcoords.clear();
	m_faces[0]->setMaterial(m_facemat);

	// Back Face
	v.m_normal = Vector(0,0,-1);
	m_faces[1] = (Primitive*) rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[1]->setType(PRIM_QUAD);
	v.m_position = Vector(-half_side,-half_side,-half_side);
	v.m_texcoords.push_back(Vector(1,0,0)); 
	m_faces[1]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,-half_side,-half_side);
	v.m_texcoords.push_back(Vector(0,0,0)); 
	m_faces[1]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,half_side,-half_side);
	v.m_texcoords.push_back(Vector(0,1,0)); 
	m_faces[1]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,half_side,-half_side);
	v.m_texcoords.push_back(Vector(1,1,0));
	m_faces[1]->addVertex(v); v.m_texcoords.clear();
	m_faces[1]->setMaterial(m_facemat);

	// Top Face
	v.m_normal = Vector(0,1,0);
	m_faces[2] = (Primitive*) rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[2]->setType(PRIM_QUAD);
	v.m_position = Vector(-half_side,half_side,half_side);
	v.m_texcoords.push_back(Vector(0,0,0));
	m_faces[2]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,half_side,half_side);
	v.m_texcoords.push_back(Vector(1,0,0)); 
	m_faces[2]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,half_side,-half_side);
	v.m_texcoords.push_back(Vector(1,1,0)); 
	m_faces[2]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,half_side,-half_side);
	v.m_texcoords.push_back(Vector(0,1,0)); 
	m_faces[2]->addVertex(v); v.m_texcoords.clear();
	m_faces[2]->setMaterial(m_facemat);

	// Bottom Face
	v.m_normal = Vector(0,-1,0);
	m_faces[3] = (Primitive*) rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[3]->setType(PRIM_QUAD);
	v.m_position = Vector(-half_side,-half_side,half_side);
	v.m_texcoords.push_back(Vector(1,0,0)); 
	m_faces[3]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,-half_side,half_side);
	v.m_texcoords.push_back(Vector(0,0,0)); 
	m_faces[3]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,-half_side,-half_side);
	v.m_texcoords.push_back(Vector(0,1,0));
	m_faces[3]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,-half_side,-half_side);
	v.m_texcoords.push_back(Vector(1,1,0)); 
	m_faces[3]->addVertex(v); v.m_texcoords.clear();
	m_faces[3]->setMaterial(m_facemat);

	// Left Face
	v.m_normal = Vector(-1,0,0);
	m_faces[4] = (Primitive*) rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[4]->setType(PRIM_QUAD);
	v.m_position = Vector(-half_side,-half_side,-half_side);
	v.m_texcoords.push_back(Vector(0,0,0)); 
	m_faces[4]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,-half_side,half_side);
	v.m_texcoords.push_back(Vector(1,0,0)); 
	m_faces[4]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,half_side,half_side);
	v.m_texcoords.push_back(Vector(1,1,0)); 
	m_faces[4]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(-half_side,half_side,-half_side);
	v.m_texcoords.push_back(Vector(0,1,0));
	m_faces[4]->addVertex(v); v.m_texcoords.clear();
	m_faces[4]->setMaterial(m_facemat);

	// Right Face
	v.m_normal = Vector(1,0,0);
	m_faces[5] = (Primitive*) rend->newObject(RND_OBJECT_PRIMITIVE);
	m_faces[5]->setType(PRIM_QUAD);
	v.m_position = Vector(half_side,-half_side,-half_side);
	v.m_texcoords.push_back(Vector(1,0,0));
	m_faces[5]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,-half_side,half_side);
	v.m_texcoords.push_back(Vector(0,0,0));
	m_faces[5]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,half_side,half_side);
	v.m_texcoords.push_back(Vector(0,1,0)); 
	m_faces[5]->addVertex(v); v.m_texcoords.clear();
	v.m_position = Vector(half_side,half_side,-half_side);
	v.m_texcoords.push_back(Vector(1,1,0)); 
	m_faces[5]->addVertex(v); v.m_texcoords.clear();
	m_faces[5]->setMaterial(m_facemat);
	
}

void Cube::render() {

	int i;
	Renderer* rend = (Renderer*) g_engine->getSubSystem(OPTIC_SUBSYS_RENDERER);

	for (i = 0; i < 6; i++) 
		rend->render(m_faces[i]);
	
}

void Cube::addTexture(Texture* texture) {
	m_textures.push_back(texture);
}

Material* Cube::getMaterial() {
	return m_facemat;
}