#include "timer.h"

Timer::Timer() : m_lastTime(0.0), m_curTime(0.0), m_lastFrameTime(0), m_numframes(0), m_fps(0) {

}

void Timer::nextFrame() {

	m_lastTime = m_curTime;

	m_curTime = timeGetTime()*0.001f;
	m_numframes++;

}

op_float Timer::getElapsedTime() const {

	return (m_curTime - m_lastTime);
}

op_float Timer::getTime() const {
	return m_curTime;
}

op_float Timer::getFPS() {

	if (m_curTime - m_lastFrameTime > 1.0) {
		m_lastFrameTime = m_curTime;
		m_fps = m_numframes;
		m_numframes = 0;
	}

	return m_fps;

}

int Timer::mark() {

	m_marks.push_back(getTime());

	return m_marks.size()-1;
}

void Timer::unmark(int index) {

	m_marks.erase(&m_marks[index]);

}

op_float Timer::markTime(int mark) {

	return (getTime() - m_marks[mark]);
}