#ifndef __RENDERABLEENTITY_H__
#define __RENDERABLEENTITY_H__

#include "entity.h"
#include "../renderer/renderer.h"
#include "../graphics/orientation.h"
#include "../graphics/aaboundingbox.h"
#include "../graphics/face.h"

class BuildParameters {
public:

	BuildParameters() { }

};

class RenderableEntity : public Entity {
public:

	RenderableEntity();
	
	virtual void build(BuildParameters*)=0;
	virtual void render()=0;
	virtual void update(op_float);

	virtual void setVertexShader(VertexShader*);
	virtual void setPixelShader(PixelShader*);
	virtual void setTextureCombiner(TextureCombiner*);
	virtual VertexShader* getVertexShader();
	virtual PixelShader* getPixelShader();
	virtual TextureCombiner* getTextureCombiner();

	virtual bool isStaticGeometry();
	virtual void setAsStatic(bool);

	virtual int getNumComponents()=0;
	virtual void getFaces(int,vector<Face>&)=0;
	virtual void getVertices(int,vector<Vertex>&)=0;

	virtual Material* getMaterial();
	virtual Orientation* getOrientation();
	virtual AABoundingBox getBoundingBox()=0;

	virtual bool QueryInterface(const EntityType, void**);

protected:

	void enableShaders();
	void disableShaders();

	Renderer* m_rend;
	Orientation* m_orien;
	Material* m_material;
	VertexShader* m_vtxshader;
	PixelShader* m_pixelshader;
	TextureCombiner* m_texcombiner;
	bool m_static;
};

#endif