#include "renderableentity.h"
#include "../core/opticengine.h"

RenderableEntity::RenderableEntity() : m_vtxshader(NULL), m_texcombiner(NULL), m_pixelshader(NULL), m_static(true) {
	
	ACQUIRE_RENDERER(m_rend,g_engine);

	m_orien = new Orientation((Transformer*)m_rend->newObject(RND_OBJECT_TRANSFORMER));
	m_material = (Material*) m_rend->newObject(RND_OBJECT_MATERIAL);
}

void RenderableEntity::update(op_float dt) {

}

Material* RenderableEntity::getMaterial() {
	return m_material;
}

Orientation* RenderableEntity::getOrientation() {
	return m_orien;
}

void RenderableEntity::setPixelShader(PixelShader* pxlshader) {
	m_pixelshader = pxlshader;
}

void RenderableEntity::setTextureCombiner(TextureCombiner* tc) {
	m_texcombiner = tc;
}

void RenderableEntity::setVertexShader(VertexShader* vs) {
	m_vtxshader = vs;
}

VertexShader* RenderableEntity::getVertexShader() {
	return m_vtxshader;
}

PixelShader* RenderableEntity::getPixelShader() {
	return m_pixelshader;
}

TextureCombiner* RenderableEntity::getTextureCombiner() {
	return m_texcombiner;
}

void RenderableEntity::enableShaders() {

	if (m_vtxshader != NULL)
		m_vtxshader->enable();
	
	if (m_pixelshader != NULL)
		m_pixelshader->enable();

	if (m_texcombiner != NULL)
		m_rend->setTexCombiner(m_texcombiner);
}

void RenderableEntity::disableShaders() {

	if (m_vtxshader != NULL)
		m_vtxshader->disable();
	
	if (m_pixelshader != NULL)
		m_pixelshader->disable();

	if (m_texcombiner != NULL)
		m_rend->setTexCombiner(NULL);
}

bool RenderableEntity::QueryInterface(const EntityType type, void** pObj) {

	if (type == Entity::RENDERABLE) {
		*pObj = (RenderableEntity*)(this);
		return true;
	}

	return false;
}

bool RenderableEntity::isStaticGeometry() {
	return m_static;
}

void RenderableEntity::setAsStatic(bool toggle) {
	m_static = toggle;
}