#ifndef __OPTICENGINE_H__
#define __OPTICENGINE_H__

#include "../renderer/renderer.h"
#include "../renderer/rendfactory.h"
#include "../graphics/graphicsmanager.h"
#include "../input/input.h"
#include "timer.h"
#include "demo.h"
#include "entity.h"
#include "callback.h"
#include "entitymanager.h"

#define	OPTIC_SUBSYS_RENDERER						0x1
#define OPTIC_SUBSYS_TIMER							0x4
#define OPTIC_SUBSYS_GRAPHICSMANAGER				0x2
#define OPTIC_SUBSYS_ENTITYMANAGER					0x5
#define OPTIC_SUBSYS_INPUT							0x3

#define ACQUIRE_ENTITYMANAGER(_v,_e)				_v = (EntityManager*) _e->getSubSystem(OPTIC_SUBSYS_ENTITYMANAGER);						
#define ACQUIRE_RENDERER(_v,_e)						_v = (Renderer*) _e->getSubSystem(OPTIC_SUBSYS_RENDERER);
#define ACQUIRE_TIMER(_v,_e)						_v = (Timer*) _e->getSubSystem(OPTIC_SUBSYS_TIMER);
#define ACQUIRE_GRAPHICSMANAGER(_v,_e)				_v = (GraphicsManager*) _e->getSubSystem(OPTIC_SUBSYS_GRAPHICSMANAGER);
#define ACQUIRE_INPUT(_v,_e)						_v = (InputManager*) _e->getSubSystem(OPTIC_SUBSYS_INPUT);

class OpticEngine : public Callback {
public:

	OpticEngine();
	virtual ~OpticEngine();

	virtual void boot(HINSTANCE,Demo*);
	virtual void shutdown();
	virtual int mainLoop();

	virtual void* getSubSystem(int);

	virtual void call(HWND,UINT,WPARAM,LPARAM);

private:
	
	void bootORS();

	HINSTANCE m_hInstance;

	Demo* m_demo;

	EntityManager* m_entman;
	GraphicsManager* m_dman;
	InputManager* m_input;
	Renderer* m_renderer;
	RendererFactory* m_rendfactory;

	Timer* m_timer;

	bool m_appactive;
};

extern OpticEngine* g_engine;

#endif