#include "opticengine.h"
#include "../graphics/octgeomman.h"

OpticEngine* g_engine;

OpticEngine::OpticEngine() : m_appactive(true) {

}

OpticEngine::~OpticEngine() {
	shutdown();
}

int OpticEngine::mainLoop() {

	MSG msg;
	op_float dt;

	m_timer->nextFrame(); m_timer->nextFrame();
	while (1) {		
		
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) { 
			
			if(msg.message == WM_QUIT)				
				break;
            
			TranslateMessage(&msg);					
            DispatchMessage(&msg);						
        }
		else { 						
		
			if (m_appactive) {
				m_input->updateDevices();

				dt = m_timer->getElapsedTime();

				m_demo->update(dt);
				m_entman->refresh(dt);

				if (m_demo->hasCustomRender())
					m_demo->render();
				else
					m_entman->getGeometry()->render();
			
				m_renderer->getWindow()->showframebuffer();		
			}
			
			m_timer->nextFrame();
        } 

	}	
	
	shutdown();

	return msg.wParam;
}

void OpticEngine::boot(HINSTANCE hInstance, Demo* demo) {

	bool octree;

	m_demo = demo;
	m_timer = new Timer();

	bootORS();

	m_renderer->getWindow()->registerCallback(WM_CHAR,this);
	m_renderer->getWindow()->registerCallback(WM_ACTIVATE,this);

	m_input = new InputManager();
	m_input->init(hInstance,m_renderer->getWindow()->getWin32Handle());

	octree = (g_configman->getSetting("octree") == "on");
	m_entman = new EntityManager(new OctreeGeometryManager(octree));

	m_dman = new GraphicsManager(m_entman,m_renderer,m_input);
	m_dman->init();

	m_entman->getGeometry()->setViewer(m_dman->getBasicViewer());

	try {
		m_demo->init();
	} catch (Exception e) {
		MessageBox(NULL,e.getMessage().c_str(),"Optic Error",MB_OK | MB_ICONSTOP);
		exit(0);
	}
}

void OpticEngine::bootORS() {

	Window* window;
	op_rect wndsize;
	int depth,full;

	try {
		m_rendfactory = new RendererFactory();
		m_rendfactory->init(m_hInstance);
		m_renderer = m_rendfactory->getRenderer(g_configman->getSetting("renderer"));
	} catch (Exception e) {
		MessageBox(NULL,e.getMessage().c_str(),"Optic Error",MB_OK | MB_ICONSTOP);
		exit(1);
	}	

	wndsize.height = atoi(g_configman->getSetting("vres").c_str()); 
	wndsize.width = atoi(g_configman->getSetting("hres").c_str()); 
	depth = atoi(g_configman->getSetting("depth").c_str()); 
	full = atoi(g_configman->getSetting("fullscreen").c_str()); 

	window = m_renderer->getWindow();
	
	try {
		window->create(string("MI Optic Game Engine: "+m_demo->getName()).c_str(),wndsize,depth,(bool)full);
	} catch (Exception e) {
		MessageBox(NULL,e.getMessage().c_str(), "Optic Error", MB_OK | MB_ICONSTOP);
		exit(1);
	}

	window->show();

	m_renderer->init();	

}

void OpticEngine::shutdown() {

	m_input->shutdown();

	delete m_input;
	delete m_renderer;
	delete m_timer;
	delete m_dman;
	delete m_rendfactory;
}

void* OpticEngine::getSubSystem(int subsys) {

	switch (subsys) {
	case OPTIC_SUBSYS_RENDERER:
		return (void*)m_renderer;
	case OPTIC_SUBSYS_TIMER:
		return (void*)m_timer;
	case OPTIC_SUBSYS_GRAPHICSMANAGER:
		return (void*)m_dman;
	case OPTIC_SUBSYS_INPUT:
		return (void*)m_input;
	case OPTIC_SUBSYS_ENTITYMANAGER:
		return (void*)m_entman;
	};

	return NULL;
}

void OpticEngine::call(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {

	switch (msg) {
	case WM_ACTIVATE:
		m_appactive = !m_appactive;
		m_input->reacquireDevices();
		break;
	case WM_CHAR:
		if (wParam == VK_ESCAPE)
			PostQuitMessage(0);
		break;
	};

}