#ifndef __ENTITYMANAGER_H__
#define __ENTITYMANAGER_H__

#include "../optic.h"
#include "../graphics/geometrymanager.h"
#include "entity.h"

class UnknownEntityException : public Exception {
public:

	UnknownEntityException() : Exception("Unknown Entity") { }
	UnknownEntityException(const string& s) : Exception("Unknown Entity: " + s) { }

};

class EntityManager {
public:

	EntityManager(GeometryManager*);

	void setGeometryManager(GeometryManager*);
	GeometryManager* getGeometry();

	Entity* create(const string&, bool autoprocess = true);

	void destroy(Entity*);

	void refresh(op_float);

private:

	GeometryManager* m_geom;
	vector<Entity*> m_ents;
	
};

#endif