#include "entitymanager.h"
#include "opticengine.h"

// Entities
#include "../graphics/terrain.h"
#include "../graphics/skybox.h"
#include "../graphics/mesh.h"
#include "../graphics/camera.h"
#include "../core/basicviewer.h"

EntityManager::EntityManager(GeometryManager* gm) : m_geom(gm) {

}

void EntityManager::refresh(op_float dt) {
	
	int i;

	//Update updateable entities

	m_geom->update(dt);

}

GeometryManager* EntityManager::getGeometry() {
	return m_geom;
}

void EntityManager::setGeometryManager(GeometryManager* geom) {
	m_geom = geom;
}

Entity* EntityManager::create(const string& entity, bool autoprocess) {
	
	Entity* ent;
	RenderableEntity* rent;
	Renderer* rend;
	InputManager* inp;
	MeshBuildParameters mbp;
	GraphicsManager* m_gm;

	if (entity == "terrain") 
		ent = new Terrain();
	else if (entity == "sphere") {
		
		m_gm = (GraphicsManager*) g_engine->getSubSystem(OPTIC_SUBSYS_GRAPHICSMANAGER);
		mbp.m_filename = g_configman->getFile("sphere.3ds");
		ent = new Mesh();

		rent = (RenderableEntity*) ent;
		rent->build(&mbp);
		rent->setVertexShader(m_gm->getStoredVertexShader(DMAN_VTXSHADER_BASIC));
		
	}
	else if (entity == "torus") {
		
		m_gm = (GraphicsManager*) g_engine->getSubSystem(OPTIC_SUBSYS_GRAPHICSMANAGER);
		mbp.m_filename = g_configman->getFile("torus.3ds");
		ent = new Mesh();

		rent = (RenderableEntity*) ent;
		rent->build(&mbp);
		rent->setVertexShader(m_gm->getStoredVertexShader(DMAN_VTXSHADER_BASIC));
	}
	else if (entity == "cube") {
		
		m_gm = (GraphicsManager*) g_engine->getSubSystem(OPTIC_SUBSYS_GRAPHICSMANAGER);
		mbp.m_filename = g_configman->getFile("cube.3ds");
		ent = new Mesh();
		
		rent = (RenderableEntity*) ent;
		rent->build(&mbp);
		rent->setVertexShader(m_gm->getStoredVertexShader(DMAN_VTXSHADER_BASIC));
		
	}
	else if (entity == "skybox")
		ent = new SkyBox();
	else if (entity == "mesh")
		ent = new Mesh();		
	else if (entity == "camera") {
		ACQUIRE_RENDERER(rend,g_engine)
		ACQUIRE_INPUT(inp,g_engine)
		ent = new Camera(rend,inp);
	}
	else if (entity == "basicviewer") {
		ACQUIRE_RENDERER(rend,g_engine)
		ACQUIRE_INPUT(inp,g_engine)
		ent = new BasicViewer(rend,new Camera(rend,inp));
	}
	else
		throw UnknownEntityException(entity);

	if (autoprocess) {
		if (ent->QueryInterface(Entity::RENDERABLE,(void**)&rent))
			m_geom->insert(rent,true,true);
	}

	m_ents.push_back(ent);

	return ent;
	
}

void EntityManager::destroy(Entity* ent) {

	int i;
	vector<Entity*> temp;

	for (i = 0; i < m_ents.size(); i++)
		if (m_ents[i] != ent)
			temp.push_back(m_ents[i]);
	
	m_ents.clear();
	for (i = 0; i < temp.size(); i++)
		m_ents.push_back(temp[i]);

	delete ent;
	ent=NULL;
}