#ifndef __CONFIGMAN_H__
#define __CONFIGMAN_H__

#include "../support/exception.h"
#include <map>
#include <string>
#include <fstream>

#include <windows.h>

#define CM_MAX_HEADINGS		3

class InvalidCMFileException : public Exception {
public:

	InvalidCMFileException() : Exception("Invalid Config Manager file") { }
	InvalidCMFileException(const string& msg) : Exception("Invalid Config Manager file: " + msg) { }
};

class UnknownCMFileException : public Exception {
public:

	UnknownCMFileException() : Exception("Requested file does not exist in config manager") { }
	UnknownCMFileException(const string& msg) : Exception("Requested file does not exist in config manager: " + msg) { }
};

class ConfigManager {
public:

	ConfigManager();

	void* init();

	// Get a XML like setting 
	string getSetting(const string&);

	// Gives absolute location of filename
	// Can be a singleton file or a member of an archive
	string getFile(const string&);

private:

	string init_settings(ifstream&);
	string init_paths(ifstream&);
	string init_demo(ifstream&);
	bool is_heading(const string&);

	void load_directory(const string&);

	map< string, string> m_settings;
	map< string, string> m_filemap;
	string m_base;
	string m_headings[CM_MAX_HEADINGS];
	void* m_demo;
};

#endif