#include "configman.h"
#include "../optic.h"
#include "demo.h"
#include "../meshdemo.h"
#include "../bumpmapdemo.h"
#include "../cubemapdemo.h"
#include "../terraindemo.h"

ConfigManager::ConfigManager() {
	m_headings[0] = "[settings]";
	m_headings[1] = "[paths]";
	m_headings[2] = "[demo]";
}

void* ConfigManager::init() {

	ifstream cfile;
	string heading;

	cfile.open("cm.cfg");

	cfile >> heading;

	while (heading != "done") {
		if (heading == m_headings[0])
			heading = init_settings(cfile);
		else if (heading == m_headings[1])
			heading = init_paths(cfile);
		else if (heading == m_headings[2])
			heading = init_demo(cfile);
		else
			throw InvalidCMFileException("Unknown Heading");
	}

	cfile.close();

	return m_demo;

}

string ConfigManager::init_demo(ifstream& cfile) {

	string demo;

	cfile >> demo;
	if (demo == "meshdemo") 
		m_demo = new MeshDemo();
	else if (demo == "bumpmapdemo")
		m_demo = new BumpMapDemo();
	else if (demo == "cubemapdemo")
		m_demo = new CubeMapDemo();
	else if (demo == "terraindemo")
		m_demo = new TerrainDemo();
	else
		throw InvalidCMFileException("Unknown Demo");

	cfile >> demo;

	return demo;
	
}

string ConfigManager::init_settings(ifstream& cfile) {

	char readbuf[256];
	string setting,value;

	while (!cfile.eof()) {

		cfile >> readbuf;

		if (is_heading(string(readbuf)))
			return (string(readbuf));

		setting = strtok(readbuf,"=");
		value = strtok(NULL,"=");

		m_settings[setting]=value;
	}

	return "done";
}

string ConfigManager::init_paths(ifstream& cfile) {

	string path;

	cfile >> m_base;
	while (!cfile.eof()) {
		cfile >> path;

		if (is_heading(path))
			return path;

		load_directory(path);
	}

	return "done";
}

bool ConfigManager::is_heading(const string& str) {

	int i;
	for (i = 0; i < CM_MAX_HEADINGS; i++)
		if (m_headings[i] == str)
			return true;

	return false;
}

void ConfigManager::load_directory(const string& dir) {

	HANDLE hFind;
	WIN32_FIND_DATA fdata;
	string searchstr;

	searchstr = m_base+dir+"\\*";
	g_log->writeLine("CONFIGMAN: SEARCHSTR: " + searchstr);
	hFind = FindFirstFile(searchstr.c_str(),&fdata);
	if (INVALID_HANDLE_VALUE == hFind)
		throw InvalidCMFileException("Could not obtain handle to: " + dir);
	
	m_filemap[toLower(string(fdata.cFileName))] = m_base+dir+string(fdata.cFileName);
	while (FindNextFile(hFind,&fdata) != 0) {
		g_log->writeLine("CONFIGMAN: NAME: " + string(fdata.cFileName) + " PATH: " + m_base+dir+string(fdata.cFileName));
		m_filemap[toLower(string(fdata.cFileName))] = m_base+dir+string(fdata.cFileName);
	}

	if (ERROR_NO_MORE_FILES != GetLastError())
		throw InvalidCMFileException(dir + "is corrupt");

	FindClose(hFind);
}

string ConfigManager::getSetting(const string& setting) {

	string filename;

	try {
		filename = m_settings[setting];
	}
	catch (...) {
		throw UnknownCMFileException(setting + "cannot be found in the config manager");
	}

	return filename;

}

string ConfigManager::getFile(const string& file) {

	string filename,lstr;
	
	lstr = toLower(file);
	try {
		filename = m_filemap[lstr];
		g_log->writeLine(string("CONFIGMAN: Retrieving File: ") + filename);
	}
	catch (...) {
		g_log->writeLine(string("CONFIGMAN: Failed: ") + file);
		throw UnknownCMFileException(lstr + "cannot be found in the config manager");
	}

	return filename;
}