#ifndef __BUMPMAPDEMO_H__
#define __BUMPMAPDEMO_H__

#include "optic.h"
#include "renderer/renderer.h"
#include "core/demo.h"
#include "core/opticengine.h"
#include "graphics/grid.h"

#define SIN_PERIOD	3.079f

class BumpMapDemo : public Demo {
public:

	BumpMapDemo();

	virtual void init();

	virtual void update(op_float);
	virtual void render();

	virtual string getName();

private:

	Renderer* m_rend;
	Timer* m_timer;
	Font* m_font;
	Grid* m_water,*m_tile;
	Texture* m_textures[5];
	TextureCombiner* m_tc;
	VertexShader* m_shader,*m_dotshader,*m_lightstate;

	Vector m_lightpos;
	op_float m_rot,m_inc;
	op_float m_anim,m_freq,m_amp; // Ripple
	int m_mark;
};

#endif