#include "bumpmapdemo.h"

BumpMapDemo::BumpMapDemo() : m_rot(0), m_inc(10.0f), m_freq(8.0f), m_amp(0.05f), m_anim(0) {

	m_lightpos = Vector(0,5,20);

	m_custrender= true;
}

void BumpMapDemo::init() {

	m_rend = (Renderer*) g_engine->getSubSystem(OPTIC_SUBSYS_RENDERER);
	m_timer = (Timer*) g_engine->getSubSystem(OPTIC_SUBSYS_TIMER);
	
	m_textures[0] = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	m_textures[0]->create(g_configman->getFile("Tile4BumpDOT3.tga").c_str(),TEXTURE_TYPE_2DMIPMAP);
	m_textures[0]->setCombineMode(TEXTURE_COMBINE_MODULATE);
	m_textures[1] = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	m_textures[1]->create(g_configman->getFile("realwater.tga").c_str(),TEXTURE_TYPE_2DMIPMAP);
	m_textures[1]->setCombineMode(TEXTURE_COMBINE_MODULATE);
	m_textures[2] = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	m_textures[2]->create(g_configman->getFile("glare.tga").c_str(),TEXTURE_TYPE_2DMIPMAP);
	m_textures[2]->setCombineMode(TEXTURE_COMBINE_MODULATE);
	m_textures[3] = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	m_textures[3]->create(g_configman->getFile("WhiteBump.tga").c_str(),TEXTURE_TYPE_2DMIPMAP);
	m_textures[3]->setCombineMode(TEXTURE_COMBINE_MODULATE);
	m_textures[4] = (Texture*) m_rend->newObject(RND_OBJECT_TEXTURE);
	m_textures[4]->create(g_configman->getFile("Tile4.tga").c_str(),TEXTURE_TYPE_2DMIPMAP);
	m_textures[4]->setCombineMode(TEXTURE_COMBINE_MODULATE);
	
	m_tc = (TextureCombiner*) m_rend->newObject(RND_OBJECT_TEXTURECOMBINER);
	m_tc->loadScript(g_configman->getFile("dot3bump.txb").c_str());

	m_shader = (VertexShader*) m_rend->newObject(RND_OBJECT_VTXSHADER);
	m_shader->load(g_configman->getFile("ripple.vsd").c_str());
	m_shader->trackMatrix(0,TRANS_MATRIX_COMPOSITE, VTXSHADER_TRANS_IDENTITY);
	m_shader->trackMatrix(4,TRANS_MATRIX_WORLD, VTXSHADER_TRANS_IDENTITY);
	m_shader->trackMatrix(8,TRANS_MATRIX_WORLD, VTXSHADER_TRANS_INVERSETRANSPOSE);
	m_shader->trackMatrix(12,TRANS_MATRIX_PROJECTION, VTXSHADER_TRANS_IDENTITY);
	m_shader->trackMatrix(16,TRANS_MATRIX_WORLD,VTXSHADER_TRANS_INVERSE);
	m_shader->setConstant(20,m_lightpos);
	m_shader->setConstant(21,Vector(0.2f,0.2f,0.2f,0.0f));
	m_shader->setConstant(22,Vector(0,0,0,0));
	m_shader->setConstant(62,Vector(1.0f/(2.0f*SIN_PERIOD),2.0f*SIN_PERIOD,SIN_PERIOD,SIN_PERIOD/2.0f));
	m_shader->setConstant(63,Vector(1.0f,1.0f/(3*2),1.0f/(5*4*3*2),1.0f/(7*6*5*4*3*2)));
	m_shader->setConstant(60,Vector(m_anim,0,0));
	m_shader->setConstant(61,Vector(m_freq,m_amp,0));

	m_dotshader = (VertexShader*) m_rend->newObject(RND_OBJECT_VTXSHADER);
	m_dotshader->load(g_configman->getFile("dot3bump.vsd").c_str());

	m_lightstate = (VertexShader*) m_rend->newObject(RND_OBJECT_VTXSHADER);
	m_lightstate->load(g_configman->getFile("lightstate.vsd").c_str());

	m_font = (Font*) m_rend->newObject(RND_OBJECT_FONT);
	m_font->create("Times New Roman",20,FONT_STYLE_BOLD,Triple(1,0,1),m_rend->getWindow());

	m_tile = new Grid();
	m_tile->addTexture(m_textures[0]);
	m_tile->addTexture(m_textures[4]);
	m_tile->addTexture(m_textures[2]);
	m_tile->setTextureCombiner(m_tc);
	m_tile->setVertexShader(m_dotshader);
	m_tile->build(20,20,10);

	m_water = new Grid();
	m_water->addTexture(m_textures[1]);
	m_water->setVertexShader(m_shader);
	m_water->build(20,20,30);
	m_water->getMaterial()->setDiffuse(Triple(1,1,1));

}

void BumpMapDemo::render() {


	m_rend->clearBuffers();

//	m_rend->setFillMode(RND_MODE_WIREFRAME);
	m_rend->getCamera()->identity();
	
	m_shader->setConstant(20,m_lightpos);
//	lightpos[0]=m_lightpos[0]; lightpos[1]=m_lightpos[1]; lightpos[2]=m_lightpos[2]; lightpos[3]= 1; 
//	m_lightstate->execute(lightpos);
	m_shader->setConstant(60,Vector(m_anim,0,0));

	m_rend->getCamera()->push();
	m_rend->getCamera()->translate(Vector(-15,0,-60));
	m_rend->getCamera()->translate(Vector(-10,-10,0));
	m_tile->render();
	m_rend->text(100,600,m_font,"DOT3 Bump Mapping w/ Vertex Shader");
	m_rend->getCamera()->pop();

	m_rend->getCamera()->push();
	m_rend->getCamera()->translate(Vector(15,0,-60));
//	m_rend->getCamera()->rotate(TRANS_AXIS_X,m_rot);
//	m_rend->getCamera()->rotate(TRANS_AXIS_Y,-m_rot);
	m_rend->getCamera()->translate(Vector(-10,-10,0));
	m_water->render();

	m_rend->text(675,600,m_font,"Ripple Vertex Shader");
	m_rend->getCamera()->pop();

	m_rend->text(10,10,m_font,"FPS: %.1f",m_timer->getFPS());
}

void BumpMapDemo::update(op_float dt) {

	m_anim -= 4.0f*dt;
	m_rot += 13.0f*dt;	
	m_lightpos[0] += m_inc*dt;

	if (m_lightpos[0] > 30) {
		m_inc = -m_inc;
		m_lightpos[0]=30;
	}

	if (m_lightpos[0] < -20) {
		m_inc = -m_inc;
		m_lightpos[0]=-20;
	}
	
}

string BumpMapDemo::getName() {

	return "Dot3 Bump Mapping Demo";
}