function aafFeat = readfeat(filename, ncep, machineformat)
%by Kshitiz Kumar
%
%this script defaults machineformat to 'ieee-be' and ncep to 13

if (nargin == 1)
    ncep = 13;
    machineformat = 'ieee-be';
elseif (nargin == 2)
    machineformat = 'ieee-be';
end

fid = fopen(filename, 'rb');
if (fid == -1)
    error('Invalid fileid');
end
% fseek(fid, 4, 'bof'); %Skip the header part -- To be compatible with
% the SPHINX format
ndim  = fread(fid, 1, 'int32', 0, 'ieee-be');
aafFeat = fread(fid, [ncep, inf], 'float32', 0, machineformat);
fclose(fid);