%If the input file extension is .wav, then MS-WAV format is assumed.
%
%If the input file extension is anything else, then SPHERE format is assumed.
%
%In all cases, the data should be PCM-encoded.
%
%MODIFIED on 10/11/11 by Mark Harvilla to include array pre-allocation
function PNCC_deployed(szOutFeatFileName, szInFileName)
    %tic;
    fid = fopen(szInFileName, 'rb');
    if strcmp(szInFileName(end-2:end),'wav') == 1
        fseek(fid, 44, 'bof');
    else 
        fseek(fid, 1024, 'bof');
    end
    ad_x  = fread(fid, 'int16');
    fclose(fid);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Flags
    %
    bPreem           = 1;
    bMedPowerBiasSub = 1;
    bPowerLaw        = 1;
    bDisplay         = 0;
    %iInitBufferSize  = 10;
    dDelta           = 0.01;
    iM               = 2;
    iN               = 4;
   
	dPowerCoeff  = 1 / 15;
	dFrameLen    = 0.0256;  % 25.6 ms window length, which is the default setting in CMU Sphinx
	dSampRate    = 16000;
	dFramePeriod = 0.010;   % 10 ms frame period
	%iPowerFactor = 1;

	iFL        = floor(dFrameLen    * dSampRate);
	iFP        = floor(dFramePeriod * dSampRate);
    iSpeechLen = length(ad_x);
	iNumFrames = 1 + floor((iSpeechLen - iFL) / iFP);
        
    
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%
	% Pre-emphasis using H(z) = 1 - 0.97 z ^ -1
    %
    if bPreem == 1
        ad_x = filter([1 -0.97], 1, ad_x);
    end
  
	iFFTSize  = 1024;
	iNumFilts = 40;
  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Obtaning the gammatone coefficient. 
    %
    % Based on M. Snelly's auditory toolbox. 
    % In actual C-implementation, we just use a table
    %
 	aad_H = ComputeFilterResponse(iNumFilts, iFFTSize);
	aad_H = abs(NormalizeFilterGain(aad_H));
    aad_P = zeros(iNumFilts,iNumFrames);
    
	i_FI       = 0;
    adSumPower = zeros(1, iNumFrames);
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%
	% Obtaining the short-time Power P(i, j)
	%
	for m = 0 : iFP : iSpeechLen  - iFL 
	ad_x_st                = ad_x(m + 1 : m + iFL) .* hamming(iFL);
        adSpec                 = fft(ad_x_st, iFFTSize);
        ad_X                   = abs(adSpec(1: iFFTSize / 2));
        %aadX(:, i_FI + 1)      = ad_X; 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        % Calculating the Power P(i, j)
        %
        for j = 1 : iNumFilts
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                %
                % Squared integration
                %
                aad_P( j , i_FI + 1)  = sum((ad_X .* aad_H(:, j)) .^ 2);
        end
        adSumPower(i_FI + 1) = sum(aad_P( : , i_FI + 1));
        i_FI = i_FI + 1;
	end

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%
	% Peak Power Normalization Using 95 % percentile
	%
	adSorted  = sort(adSumPower);
	dMaxPower = adSorted(round(0.95 * length(adSumPower)));
	aad_P     = aad_P / max(dMaxPower,eps) * 1e15;
    
    if bMedPowerBiasSub == 1
        aad_Q      = zeros(iNumFilts,iNumFrames);
        aad_tildeQ = aad_Q;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        % Medium-duration power calculation
        % 
        for j = 1 : iNumFrames,
             for i = 1 : iNumFilts,
                aad_Q(i, j) =  mean(aad_P(i, max(1, j - iM) : min(iNumFrames, j + iM)));
             end
        end
        
        aad_w        = zeros(size(aad_Q));
        aad_w_Smooth = zeros(size(aad_Q));

        for i = 1 : iNumFilts,
            aad_tildeQ(i, :) = PowerBiasSub(aad_Q(i, :), dDelta);
            aad_w(i, :)      = max(aad_tildeQ(i, :), eps) ./ max(aad_Q(i, :), eps);
        end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        % Weight smoothing aross channels
        % 
        for j = 1 : iNumFrames,
            for i = 1 : iNumFilts,
                aad_w_Smooth(i, j) = mean(aad_w(max(i - iN , 1) : min(i + iN , iNumFilts) , j));
            end   
        end

        aad_P = aad_w_Smooth .* aad_P; 

    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Apply the nonlinearity
    %
    if bPowerLaw == 1
        aadSpec = aad_P .^ dPowerCoeff;
    else
        aadSpec = log(aad_P + eps);
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % DCT
    %
    aadDCT                  = dct(aadSpec);
    aadDCT(14:iNumFilts, :) = [];
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % CMN
    %
    for i = 1 : 13
           aadDCT(i, : ) = aadDCT(i, : ) - mean(aadDCT(i, : ));
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Writing the feature in Sphinx format
    %
    [iM, iN] = size(aadDCT);
    iNumData = iM * iN;
    fid = fopen(szOutFeatFileName, 'wb');
    fwrite(fid, iNumData, 'int32');
    %iCount = fwrite(fid, aadDCT(:), 'float32');
    fwrite(fid, aadDCT(:), 'float32');
    fclose(fid);
      
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Display
    %
    if bDisplay == 1
        figure
        aadSpec = idct(aadDCT, iNumFilts);
        imagesc(aadSpec); axis xy;
    end
    %toc;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Power Bias Subtraction Algorithm
%
% Bias level is obtained by maximizing the AM-GM ratio
% 
function [ad_tildeQ] = PowerBiasSub(ad_Q, dDelta)
  
      dNormPower = 1e15;
      ad_B  = [0 dNormPower ./ (10 .^((70 : -1 : 10) / 10) + 1)];
      
      d_tildeGTemp = 0;
      ad_tildeQSave   = ad_Q;
  
      for d_B = ad_B
          
          aiIndex       = find(ad_Q > d_B);
          if isempty(aiIndex)
              break
          end
         
          dPosMean = mean(ad_Q(aiIndex) - d_B);
          aiIndex       = find(ad_Q > d_B + dDelta *  dPosMean);
          if isempty(aiIndex)
              break
          end
          
          d_cf      = mean(ad_Q(aiIndex) - d_B) * dDelta;
          ad_tildeQ = max(ad_Q - d_B, d_cf);
          adData    = ad_tildeQ(aiIndex);
  
          d_tildeG = log(mean(adData)) - mean(log(adData));
          if (d_tildeG > d_tildeGTemp)
              ad_tildeQSave = ad_tildeQ;
              d_tildeGTemp  = d_tildeG;
          end
      end
  
      ad_tildeQ = ad_tildeQSave;
  end
