function pncc_wrapper(filelist,config_options)

%%%%%%%%%%%%
% default parameters
% and reading config file
if nargin == 1
	fs        = 16000;
	feat_name = 'cmu_feat';
	appDeltas = 1;
	del_width = 5;
	numFilts  = 40;
	dLowFreq  = 200;
	dHighFreq = 8000;
	cmn       = 1;
	fileType  = 'sph';
	addDither = 1;
	overwrite = 0;
	pbs       = 1;
	ppn       = 1;
        numDeltas = 2;
else
	fid = fopen(config_options);
	CO1 = textscan(fid,'%s%s','MultipleDelimsAsOne',1);
	fclose(fid);

	pVals = CO1{2};

	fs        = str2double(pVals{1});
	feat_name = pVals{2};
	appDeltas = str2double(pVals{3});
	del_width = str2double(pVals{4});
	numFilts  = str2double(pVals{5});
	dLowFreq  = str2double(pVals{6});
	dHighFreq = str2double(pVals{7});
	cmn       = str2double(pVals{8});
	fileType  = pVals{9};
	addDither = str2double(pVals{10});
	overwrite = str2double(pVals{11});
	pbs       = str2double(pVals{12});
	ppn       = str2double(pVals{13});
        numDeltas = str2double(pVals{14});
end

%%%%%%%%%%%%
% read in I/O
% list
fid = fopen(filelist);
L1  = textscan(fid,'%s%s','delimiter',',');
fclose(fid);

%%%%%%%%%%%%
% generate common
% filter bank
aad_H = ComputeFilterResponse(numFilts, 1024, dLowFreq, dHighFreq, fs);
aad_H = abs(NormalizeFilterGain(aad_H, fs));

%%%%%%%%%%%%
% successively process
% the files
inList = L1{1}; outList = L1{2};
for k = 1:length(inList)
	inFile  = strtrim(inList{k});
	outFile = strtrim(outList{k});
	
	file_dir = fileparts(outFile);
	if exist(file_dir,'dir') ~= 7
		mkdir(file_dir);
	end
	
	if overwrite == 0	
		if ~exist(outFile,'file')
			pncc(outFile,inFile,feat_name,fs,numDeltas,appDeltas,del_width,cmn,fileType,addDither,pbs,ppn,aad_H);
		end
	else
		pncc(outFile,inFile,feat_name,fs,numDeltas,appDeltas,del_width,cmn,fileType,addDither,pbs,ppn,aad_H);
	end
end
