function pncc(szOutFeatFileName,szInFileName,feat_name,fs,appDeltas,del_width,numFilts,dLowFreq,dHighFreq,cmn,fileType,addDither)
    
    fid = fopen(szInFileName, 'rb');
    if strcmp(fileType,'wav') == 1
       fseek(fid, 44, 'bof');
    else 
       fseek(fid, 1024, 'bof');
    end
    ad_x = fread(fid, 'int16');
    fclose(fid);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Flags
    %
    bPreem           = 1;
    bMedPowerBiasSub = 1;
    bPowerLaw        = 1;
    bDisplay         = 0;
    %iInitBufferSize  = 10;
    dDelta           = 0.01;
    iM               = 2;
    iN               = 4;
   
	dPowerCoeff  = 1 / 15;
	dFrameLen    = 0.0256;  % 25.6 ms window length, which is the default setting in CMU Sphinx
	dSampRate    = fs;
	dFramePeriod = 0.010;   % 10 ms frame period

	iFL = floor(dFrameLen    * dSampRate);
	iFP = floor(dFramePeriod * dSampRate);
    
    	if length(ad_x) < iFL+iFP %need at least 2 frames
        	if size(ad_x,2) == 1
            		ad_x = [ad_x;zeros(iFL+iFP-length(ad_x),1)];
        	else
            		ad_x = [ad_x,zeros(1,iFL+iFP-length(ad_x))];
        	end      
    	end
   
    	iSpeechLen = length(ad_x);
    	iNumFrames = 1 + floor((iSpeechLen - iFL) / iFP);

	%%%%%%%%%%%%
	% add dither to avoid
	% artificial zeros (from UTD CRSS)
	if addDither == 1
        	dither = rand(length(ad_x), 1) + rand(length(ad_x), 1) - 1;
        	spow   = std(ad_x);
        	ad_x   = ad_x + 1e-6 * spow * dither;
	end

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%
	% Pre-emphasis using H(z) = 1 - 0.97 z ^ -1
    	%
    	if bPreem == 1
        	ad_x = filter([1 -0.97], 1, ad_x);
    	end
  
	iFFTSize  = 1024;
	iNumFilts = numFilts;
  
    	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    	%
    	% Obtaning the gammatone coefficient. 
    	%
    	% Based on M. Snelly's auditory toolbox. 
    	% In actual C-implementation, we just use a table
    	%
	aad_H = ComputeFilterResponse(iNumFilts,iFFTSize,dLowFreq,dHighFreq,dSampRate);
	aad_H = NormalizeFilterGain(abs(aad_H));
    	aad_P = zeros(iNumFilts,iNumFrames);
    
	i_FI       = 0;
    	adSumPower = zeros(1, iNumFrames);
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%
	% Obtaining the short-time Power P(i, j)
	%
	for m = 0 : iFP : iSpeechLen  - iFL 
	ad_x_st                = ad_x(m + 1 : m + iFL) .* hamming(iFL);
        adSpec                 = fft(ad_x_st, iFFTSize);
        ad_X                   = abs(adSpec(1: iFFTSize / 2));
        %aadX(:, i_FI + 1)      = ad_X; 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        % Calculating the Power P(i, j)
        %
        for j = 1 : iNumFilts
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                %
                % Squared integration
                %
                aad_P( j , i_FI + 1)  = sum((ad_X .* aad_H(:, j)) .^ 2);
        end
        adSumPower(i_FI + 1) = sum(aad_P( : , i_FI + 1));
        i_FI = i_FI + 1;
	 %[m, iSpeechLen  - iFL]
	end
	
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%
	% Peak Power Normalization Using 95 % percentile
	%
	adSorted  = sort(adSumPower);
	dMaxPower = adSorted(round(0.95 * length(adSumPower)));
	aad_P     = aad_P / max(dMaxPower,eps) * 1e15;
    
    if bMedPowerBiasSub == 1
        aad_Q      = zeros(iNumFilts,iNumFrames);
        aad_tildeQ = aad_Q;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        % Medium-duration power calculation
        % 
        for j = 1 : iNumFrames,
             for i = 1 : iNumFilts,
                aad_Q(i, j) =  mean(aad_P(i, max(1, j - iM) : min(iNumFrames, j + iM)));
             end
        end
        
        aad_w        = zeros(size(aad_Q));
        aad_w_Smooth = zeros(size(aad_Q));

        for i = 1 : iNumFilts,
            aad_tildeQ(i, :) = PowerBiasSub(aad_Q(i, :), dDelta);
            aad_w(i, :)      = max(aad_tildeQ(i, :), eps) ./ max(aad_Q(i, :), eps);
        end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        % Weight smoothing aross channels
        % 
        for j = 1 : iNumFrames,
            for i = 1 : iNumFilts,
                aad_w_Smooth(i, j) = mean(aad_w(max(i - iN , 1) : min(i + iN , iNumFilts) , j));
            end   
        end

        aad_P = aad_w_Smooth .* aad_P; 

    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Apply the nonlinearity
    %
    if bPowerLaw == 1
        aadSpec = aad_P .^ dPowerCoeff;
    else
        aadSpec = log(aad_P + eps);
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % DCT
    %
    aadDCT                  = dct(aadSpec);
    aadDCT(14:iNumFilts, :) = [];
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % CMN
    %
    if cmn == 1
    	for i = 1 : 13
           aadDCT(i, : ) = aadDCT(i, : ) - mean(aadDCT(i, : ));
    	end
    end
    
    if appDeltas == 1
    	%%%%%%%%%%%%
    	% compute deltas
    	%
    	d1     = deltas(aadDCT,del_width);
    	d2     = deltas(d1,del_width);	
	aadDCT = [aadDCT;d1;d2];
    end
    %%%%%%%%%%%%
    % write feature
    %
    writesri(aadDCT,feat_name,szOutFeatFileName);
    %writefeat(szOutFeatFileName,aadDCT);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Power Bias Subtraction Algorithm
%
% Bias level is obtained by maximizing the AM-GM ratio
% 
function [ad_tildeQ] = PowerBiasSub(ad_Q, dDelta)
  
      dNormPower = 1e15;
      ad_B  = [0 dNormPower ./ (10 .^((70 : -1 : 10) / 10) + 1)];
      
      d_tildeGTemp = 0;
      ad_tildeQSave   = ad_Q;
  
      for d_B = ad_B
          
          aiIndex       = find(ad_Q > d_B);
          if isempty(aiIndex)
              break
          end
         
          dPosMean = mean(ad_Q(aiIndex) - d_B);
          aiIndex       = find(ad_Q > d_B + dDelta *  dPosMean);
          if isempty(aiIndex)
              break
          end
          
          d_cf      = mean(ad_Q(aiIndex) - d_B) * dDelta;
          ad_tildeQ = max(ad_Q - d_B, d_cf);
          adData    = ad_tildeQ(aiIndex);
  
          d_tildeG = log(mean(adData)) - mean(log(adData));
          if (d_tildeG > d_tildeGTemp)
              ad_tildeQSave = ad_tildeQ;
              d_tildeGTemp  = d_tildeG;
          end
      end
  
      ad_tildeQ = ad_tildeQSave;
  end
