#!/bin/sh
# script for execution of deployed applications
#
# Sets up the MCR environment for the current $ARCH and executes 
# the specified command.
#
# Modified by Mark Harvilla for use with the pncc_wrapper binary
#
# Mark Harvilla
# Carnegie Mellon University
# mharvill@cs.cmu.edu
# November 16, 2011
exe_name=$0
exe_dir=`dirname "$0"`

flag=0 #flag for usage display
if [ $# = 0 -o $# -gt 2 ]; then #if number of inputs is zero or greater than two
  flag=1
elif [ $1 = "-h" ]; then #if input is -h
  flag=1
fi

if [ $flag -eq 1 ]; then #if the flag is set, display the usage -- otherwise, run the program
  echo "Usage: ./go_pncc_wrapper.sh <filelist> <config_file>"
  echo " "
  echo "Power-Normalized Cepstral Coefficients (PNCC)"
  echo "version 1.0"
  echo " "
  echo "Developed by Dr. Chanwoo Kim"
  echo "Adapted by Mark Harvilla (mharvill@cs.cmu.edu)"
  echo "Carnegie Mellon University"
  echo "November 16, 2011"
else
  MCRROOT=/net/juniper/opt/MATLAB/MATLAB_Compiler_Runtime/v714 ;
  LD_LIBRARY_PATH=.:${MCRROOT}/runtime/glnxa64 ;
  LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRROOT}/bin/glnxa64 ;
  LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRROOT}/sys/os/glnxa64;
	MCRJRE=${MCRROOT}/sys/java/jre/glnxa64/jre/lib/amd64 ;
	LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}/native_threads ; 
	LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}/server ;
	LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE}/client ;
	LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${MCRJRE} ;  
  XAPPLRESDIR=${MCRROOT}/X11/app-defaults ;
  export LD_LIBRARY_PATH;
  export XAPPLRESDIR;
  args=
  while [ $# -gt 0 ]; do
      token=`echo "$1" | sed 's/ /\\\\ /g'`   # Add blackslash before each blank
      args="${args} ${token}" 
      shift
  done
  eval "${exe_dir}"/pncc_wrapper $args
fi
exit
