function pncc2_dscc(outFile,inFile,feat_name,fs,ndeltas,appDeltas,del_width,cmn,fileType,addDither,pbs,ppn,aad_H,numcep,skipC0,deltaSpec,spb,hard_limit,start_times,end_times)
%
%This function optionally appends delta-spectral cepstral coefficients (DSCC) to PNCC
%
%PNCC & SPB developed by Chanwoo Kim
%DSCC developed by Kshitiz Kumar
%
%Adapted by Mark Harvilla
%July 11, 2012



for kk = 1:length(start_times)
	[P,FIRST_FRAME,LAST_FRAME] = pncc_w_spb_corrected(inFile,fs,fileType,addDither,pbs,ppn,aad_H,spb,hard_limit,start_times(kk),end_times(kk)); 
	%produces a linear-amplitude spectral representation, as before the log in MFCCs
	P = transpose(P);
	if kk == 1
		P_NaN = NaN(size(P));
		P_NaN(:,FIRST_FRAME:LAST_FRAME) = P(:,FIRST_FRAME:LAST_FRAME);
	else
		P_NaN(:,FIRST_FRAME:LAST_FRAME) = P(:,FIRST_FRAME:LAST_FRAME);
	end
end

P = P_NaN;
nonlP = P.^(1/15); %using power-law, as in PNCC

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% DCT & CEPSTRAL LIFTERING
%
aadDCT = dct(nonlP)';

iNumFilts = size(aad_H,2);
if skipC0 == 1
	aadDCT(:, numcep+2:iNumFilts) = [];
	aadDCT(:, 1) = [];
else
	aadDCT(:, numcep+1:iNumFilts) = [];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CMN
%
if cmn == 1
    for i = 1 : numcep
           aadDCT( :, i ) = aadDCT( : , i ) - nanmean(aadDCT( : , i));
    end
end

aadDCT = aadDCT';

if appDeltas == 1
    if deltaSpec == 0
    	%%%%%%%%%%%%
    	% compute deltas
    	%
	ncep = size(aadDCT,1);
	final_feat = zeros(ncep*(1+ndeltas),size(aadDCT,2));
	final_feat(1:ncep,:) = aadDCT;
    	for nd = 1:ndeltas
    		d1 = deltas(final_feat((nd-1)*ncep+1:nd*ncep,:),del_width);
		final_feat(nd*ncep+1:(nd+1)*ncep,:) = d1;
    	end
    else
	%T = 1+ndeltas;
	T = min(1+ndeltas,size(P,2)-1);
	DSCC = specD_mod(P, T, numcep, ndeltas);
	final_feat = [aadDCT; DSCC];	
    end
else
	final_feat = aadDCT;
end

writesri(final_feat,feat_name,outFile); 
