function [nfeat] = gauss_histn(feat)

% For batch jobs the function should be modified to do norminv only once

nfeat = [];
for i = 1:size(feat, 1)
    nfeat(i,:) = gauss_histn_vec(feat(i,:));
end

function [nfeat] = gauss_histn_vec(feat)
L = length(feat);

[feat_val,  feat_idx] = sort(feat);

sort_idx = ([1:L]- 0.5)/L ;
sort_val = norminv(sort_idx, 0, 1);

nfeat(feat_idx) = sort_val;