function [Cdelta] = specD(spec, T, Ncep, ndeltas)

% takes a power spectral matrix and obtains delta-spec

delta = diag_feat_T_F(spec, T, 0);

NLdelta = gauss_histn(delta);

Cdelta = dct(NLdelta);
Cdelta = Cdelta(1:Ncep,:);

lastCdelta = Cdelta;
for kk = 1:ndeltas-1
	Cddelta = diag_feat_T_F(lastCdelta, max(T-kk, 1), 0);
	Cdelta  = [Cdelta; Cddelta];
	lastCdelta = Cddelta;	
end

Cdelta = mean_var_norm(Cdelta);
