#!/usr/local/bin/perl5 -w
#
# Simple test driver for UniRand's "best_match" fitter.

use strict;
use lib '/usr/lw2j/private/Stat/Perl';
use FileHandle;

require UniRand;

autoflush STDOUT 1;
# Snarf data from STDIN.  Maybe it fits in memory...
# Assume it to be univariate already.

my @data     = <STDIN>;
my @dists_used = ();

@data = grep { /\S/ } @data;
my $n        = scalar @data;

print "Read $n items.\n";


{
  my $sample_size = 5000;

  if ($n > $sample_size) {
    # Take a sample of at most size $sample_size.
    my %keytable = ();

    print "Generating sample of size $sample_size.\n";

    map { $keytable{$_} = rand() } @data;

    my @sample = sort { $keytable{$a} <=> $keytable{$b} } @data;
    splice @sample, $sample_size;

    print "Sample generated.  Making initial fits...\n";


    my @initial_fits = UniRand::best_match(\@sample, 0.2);
    my $name_idx     = $UniRand::MATCH_INDICES{"name"};
    my $est_idx      = $UniRand::MATCH_INDICES{"est"};
    my $pnames_idx   = $UniRand::MATCH_INDICES{"param_names"};

    defined($name_idx) || die;
    defined($est_idx)  || die;
    defined($pnames_idx) || die;

    @dists_used = map { +[ $_->[$name_idx],
    $_->[$est_idx],
    $_->[$pnames_idx] ] } @initial_fits;
    my $dist_ct = scalar @dists_used;
    my $dist_total_ct = scalar (@UniRand::DIST_LIST_PLAIN);

    print "\n\n", "=" x 70, "\n", "Sample fits:\n", "=" x 70, "\n";
    UniRand::fit_report(@initial_fits);
  }
}


my @final_fits = UniRand::best_match(\@data, 0.2, undef, undef, @dists_used);
print "\n\n", "=" x 70, "\n", "Final fits:\n", "=" x 70, "\n";
UniRand::fit_report(@final_fits);
