: # Find Perl
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/bin/perl5 -w
#
############################################################
# $Id: TriGen.pl,v 1.7 2003/10/15 14:14:23 lw2j Exp $
#
# $Log:	TriGen.pl,v $
# Revision 1.7  2003/10/15  14:14:23  lw2j
# Slashed storage cost.
# 
# Revision 1.6  2002/01/03  10:54:12  lw2j
# Untabified.
# 
# Revision 1.5  2001/08/22  17:21:29  lw2j
# Untabified (tab=8).
#
# Revision 1.4  2001/05/29  18:04:21  lw2j
# Changed <space><tab><space> to simply <space> in output.
#
# Revision 1.3  2000/10/03  14:48:53  lw2j
# Fixed a header typo.
#
# Revision 1.2  2000/10/03  14:08:01  lw2j
# Added magic perl invoker.
#
# Revision 1.1  2000/07/18  13:27:11  lw2j
# Initial revision
#
############################################################
#
# A simple queue-based Sierpinski triangle generator.
#
# It's very simple because it's meant solely as a (small)
# test generator.
#
# Since the queue is stored in memory, it's quite easy to
# ask for so many points that thrashing starts, all RAM and
# swap is exhausted, and horrific things happen.  Don't do
# this.
#
# No output besides the two-dimensional points is provided.
# No error checking is done.
#


my @queue     = ();
my $count     = 0;
my $limit     = shift @ARGV;
my $queued    = 3;

if (!defined($limit)) {
    $limit = 1000;
}

push @queue, +[+[0, 0], +[1, 0], +[0.5, 0.8660254]];


# Given the triangle specified by 0-1-2, we output
# those points (in that order) and then queue 0-3-4,
# 4-5-2, and 3-1-5.
#
#         2
#        / \
#       4---5
#      / \ / \
#     0---3---1
#

while ($count < $limit) {
    my $tri = shift @queue;

    my $x0 = $tri->[0]->[0];
    my $y0 = $tri->[0]->[1];
    my $x1 = $tri->[1]->[0];
    my $y1 = $tri->[1]->[1];
    my $x2 = $tri->[2]->[0];
    my $y2 = $tri->[2]->[1];

    print "$x0 $y0\n";

    if ((++$count) == $limit) {
        last;
    }

    print "$x1 $y1\n";

    if ((++$count) == $limit) {
        last;
    }

    print "$x2 $y2\n";

    if ((++$count) == $limit) {
        last;
    }

    my $x3 = ($x0+$x1)/2;
    my $y3 = $y0;
    my $x4 = ($x0+$x3)/2;
    my $y4 = ($y0+$y2)/2;
    my $x5 = ($x3+$x1)/2;
    my $y5 = $y4;

    if ($queued < $limit) {
        push @queue, +[+[$x0, $y0], +[$x3, $y3], +[$x4, $y4]];

				$queued += 3;
        if ($queued < $limit) {
            push @queue, +[+[$x4, $y4], +[$x5, $y5], +[$x2, $y2]];

						$queued += 3;
            if ($queued < $limit) {
                push @queue, +[+[$x3, $y3], +[$x1, $y1], +[$x5, $y5]];
            }
        }
    }
}

exit 0;
