: # Use perl...
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/bin/perl5 -w
#
############################################################
# $Id: Pair_Count.pl,v 1.8 2002/01/03 10:53:35 lw2j Exp $
############################################################
# $Log:	Pair_Count.pl,v $
# Revision 1.8  2002/01/03  10:53:35  lw2j
# Untabified.
#
# Revision 1.7  2001/12/17  12:38:24  lw2j
# Restored old 'use lib' line so the FDC patch works fine.
#
# Revision 1.6  2001/12/16  15:52:26  lw2j
# Switched to Wrapper.pm.
#
# Revision 1.5  2001/08/22  17:21:29  lw2j
# Untabified (tab=8).
#
# Revision 1.4  2001/08/03  11:22:31  lw2j
# Changed print_args_and_exit to note that r_count does take an
# argument (added 'nn').
#
# Revision 1.3  2001/08/03  11:21:20  lw2j
# Now aware of o_max and s_max options.
#
# Revision 1.2  2001/06/01  15:09:40  lw2j
# Now can use SimpleWrapper to support memory loads.  Ditto -m for
# on-disk files.
#
# Revision 1.1  2001/05/29  18:04:21  lw2j
# Initial revision
#
############################################################
# Forked from fd.pl, version 1.1.
############################################################
# Revision 1.1  2000/11/12  14:41:06  lw2j
# Initial revision
#
# Revision 1.3  2000/10/24  18:00:46  lw2j
# Standardized path.
#
# Revision 1.2  2000/10/03  14:08:01  lw2j
# Added magic perl invoker.
#
# Revision 1.1  2000/07/18  13:27:11  lw2j
# Initial revision
#
############################################################
#
# A simple demo to invoke the Pair_Count package on a
# single file and print the log/log data in an obvious
# format -- one log radius/log count pair per line, separated by
# whitespace.
#
# It accepts all the options that the old fd.pl used to,
# except for verbose (which isn't meaningful anymore,
# because this script prints the log/log by default,
# rather than normally only the FD).
#
use strict;

##### <change_me>
#
# Change this to where you placed the modules.
#
use lib '/afs/cs.cmu.edu/user/lw2j/shared/FracDim/FracDim';
##### </change_me>

use Symbol;


require Wrapper;
require Pair_Count;

{
    my $in_fh   = gensym;
    my $dw_obj  = undef;

    # parse arguments
    my ($params_ref, $fname) = parse_arguments();

    if (defined($fname)) {
        open($in_fh, $fname) || die "Failed to open '$fname':  $!";

        if (exists($params_ref->{'memory'})) {
          # The new Wrapper module, by default, buffers in memory
          # (BUFFER_PACK).
          $dw_obj = new Wrapper($in_fh);
        } else {
          # Switch to NO_BUFFER.
          $dw_obj = new Wrapper($in_fh);
          $dw_obj->set_buffer($dw_obj->{"NO_BUFFER"});
        }
    } else {
        $in_fh = \*STDIN;
        $dw_obj = Wrapper::new Wrapper($in_fh);
    }

    if (exists($params_ref->{'memory'})) {
        delete $params_ref->{'memory'};
    }


    $params_ref->{'data_o'} = $dw_obj;


    my $pc_obj = new Pair_Count(%{$params_ref});
    my ($log_radius_ref, $log_pairs_ref) = $pc_obj->pair_count();


    # print pairs
    my $ct = scalar @{$log_radius_ref};
    my $i  = 0;

    die unless ((scalar @{$log_pairs_ref}) == $ct);

    for ($i=0; $i < $ct; $i++) {
        my $log_r = $log_radius_ref->[$i];
        my $log_p = $log_pairs_ref->[$i];

        print "$log_r $log_p\n";
    }

    if (defined($fname)) {
        close($in_fh);
    }

    exit 0;
}



#####################
sub print_usage_and_exit() {
    use File::Basename;

    my $progname = basename($0);

    print "$progname -- Interact with the Pair_Count.pm module\n";
    print "Usage:\n";
    print "\n";
    print "$progname [-s] [-m] [-q nn] [-r_min nn] [-r_max nn]\n";
    print "          [-r_count nn] [-intervals]  [-s_max nn]\n";
    print "          [-density_max nn] [filename]\n";
    print "\n";
    print "Exact parameter semantics are defined by the module.\n";
    print "\n";
    print " -s          Use the slow all-pairs method for C2 -- more\n";
    print "             precise, but perhaps unbearably slow and vile\n";
    print "             in terms of memory consumption.\n";
    print " -m          Load all data into memory, even if from a file.\n";
    print " -q          Box-counting exponent.\n";
    print " -r_min      Minimum radius the module will consider using.\n";
    print " -r_max      Maximum radius it'll try.\n";
    print " -r_count    Maximum number of radii it'll try.\n";
    print " -s_max      Maximum fraction of occupied cells to be\n";
    print "             singletons, when reducing radius.\n";
    print " -o_max      Maximum fraction of objects to be in ONE\n";
    print "             cell, when increasing radius.\n";
    print " -intervals  The number of intervals for the all-pairs\n";
    print "             method.\n";
    print "\n";
    print "The options after -s are all specific to box-counting, except\n";
    print "for 'intervals', which is specific to the all-pairs method.\n";
    print "\n";
    print "The filename must correspond to a vector data file, with\n";
    print "one equal-dimensioned vector per line, separated by\n";
    print "whitespace or commas.  Comments are to be delineated with\n";
    print "semicolons.  If NOT present, input must be provided on\n";
    print "STDIN.\n";
    exit 0;
}


# Returns a reference to a hash table of parameters,
# and a scalar containing the filename.
#
# Always uses @ARGV0.
#
sub parse_arguments() {
    my $arg;
    my $fname  = undef;
    my %params = ();

    while (defined($arg = $ARGV[0]) && ($arg =~ /^-/)) {
        $arg = shift @ARGV;

        if ($arg eq '-s') {
            $params{'method'}  = 'slow';
        } elsif ($arg eq '-m') {
            $params{'memory'} = 1;
        } elsif (($arg eq '-q')       ||
                 ($arg eq '-r_min')   ||
                 ($arg eq '-r_max')   ||
                 ($arg eq '-r_count') ||
                 ($arg eq '-s_max') ||
                 ($arg eq '-o_max') ||
                 ($arg eq '-intervals')) {

            $arg =~ s/^-//;
            my $val = shift @ARGV;

            defined($val) || die "Failed to supply value for -$arg";

            if ($val ne 'undef') {
                $params{$arg} = $val;
            } else {
                $params{$arg} = undef;
            }
        } elsif ($arg eq '--') {
            last;
        } else {
            print_usage_and_exit();
        }
    }
    $fname   = shift @ARGV;

    return (\%params, $fname);
}
