: # Find Perl
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/bin/perl5 -w
#
############################################################
############################################################
# $Id: LineGen.pl,v 1.3 2002/01/03 10:51:57 lw2j Exp $
#
# $Log:	LineGen.pl,v $
# Revision 1.3  2002/01/03  10:51:57  lw2j
# Minor changes.
#
# Revision 1.2  2001/08/22  17:21:29  lw2j
# Untabified (tab=8).
#
# Revision 1.1  2000/10/25  15:50:18  lw2j
# Initial revision
#
#
############################################################
#
# Generate points unevenly spaced on a non-noisy,
# non-axis-aligned line embedded in 50 dimensions.
#
# The pattern is
#
#              111111111122222222223333333333444444444
#    0123456789012345678901234567890123456789012345678
#    A           C           D           E           B
#
#    Given line segment AB, we queue AC and DE,
#    in that order.
#
# An infinite set of points generated this way should
# have a fractal dimension of 0.5, if I'm not mistaken.
#
# We note that our method is based on an in-memory queue
# (list, really) and obviously can consume as much
# memory as you dare as it makes zero attempt to
# conserve.

# The sole argument is the number of points to generate.

#
# These numbers were generated via Perl's pseudorandom
# number generator.  Numbers specified here explicitly
# in order to avoid the possibility of different RNG
# implementations on different systems.
#

use strict;

# Ditto.
my @endpoint_a =
    qw(
       0.155 0.534 0.76  0.411 0.253
       0.198 0.863 0.143 0.205 0.368
       0.941 0.168 0.712 0.256 0.266
       0.68  0.466 0.472 0.373 0.428
       0.506 0.742 0.017 0.91  0.507
       0.939 0.668 0.663 0.554 0.007
       0.525 0.71  0.541 0.285 0.121
       0.795 0.483 0.984 0.938 0.689
       0.353 0.88  0.858 0.065 0.137
       0.124 0.746 0.603 0.597 0.119
       );

my $dims       = scalar @endpoint_a;
my @endpoint_b =
    qw(
       0.111 0.13  0.298 0.57  0.304
       0.925 0.627 0.762 0.371 0.229
       0.837 0.277 0.068 0.744 0.657
       0.195 0.519 0.281 0.211 0.211
       0.486 0.265 0.161 0.015 0.657
       0.737 0.081 0.446 0.914 0.043
       0.13  0.026 0.173 0.429 0.597
       0.477 0.354 0.224 0.239 0.725
       0.453 0.077 0.003 0.522 0.822
       0.66  0.717 0.341 0.941 0.929
       );

die unless ((scalar @endpoint_b) == $dims);


my $point_count = shift @ARGV;
my @queue       = ( +[ \@endpoint_a, \@endpoint_b ] );

(defined($point_count) && ($point_count > 0) &&
 ($point_count == int($point_count))) ||
    die "Positive integers only, please.";


main_loop: {
    my $segment_ref     = shift @queue;
    my ($a_ref, $b_ref) = @{$segment_ref};
    my @a_list          = @{$a_ref};
    my @b_list          = @{$b_ref};

    (($point_count--) == 0) && last main_loop;

    print join(' ', @{$a_ref}), "\n";

    (($point_count--) == 0) && last main_loop;

    print join(' ', @{$a_ref}), "\n";

    if ($point_count > 0) {

        my @c_list = (0) x $dims;
        my @d_list = (0) x $dims;
        my @e_list = (0) x $dims;
        my $i      = 0;

        for ($i=0; $i < $dims; $i++) {
            my $a       = shift @a_list;
            my $b       = shift @b_list;
            my $delta   = 0.25*($b - $a);

            $c_list[$i] = $a + $delta;
            $d_list[$i] = $a + (2*$delta);
            $e_list[$i] = $a + (3*$delta);
        }

        push @queue, +[ $a_ref,   \@c_list ];
        push @queue, +[ \@d_list, \@e_list ];

        redo main_loop;
    }
}

