: # Use perl...
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/local/bin/perl5 -w
#
# Or merely replace with the above, but then be prepared
# with a substitution script when changing systems.
# *shrug*
#
# This is a simple script for using 'TrimFlat.pm'.
#
# Given input on <STDIN> with the format
#
#    x1  y1
#    x2  y2
#    ...
#    xn  yn
#
# (IOW, multiple lines, each containing exactly one pair
#  of x and y coordinates, whitespace-separated),
#
# it will use the TrimFlat module to compute a subset of
# points, formatted identically, that theoretically
# has no "flat" regions at either the begining or the end.
#
# The x-y pairs must be sufficiently few so that they
# can be stored in memory, but this will seldom be an
# issue, and could readily be solved if need be.
#
##########################################################################
# $Id: Trim_Flat.pl,v 1.3 2002/01/03 10:54:12 lw2j Exp $
# $Log:	Trim_Flat.pl,v $
# Revision 1.3  2002/01/03  10:54:12  lw2j
# Untabified.
# 
# Revision 1.2  2001/08/22  17:21:29  lw2j
# Untabified (tab=8).
#
# Revision 1.1  2001/05/29  18:04:21  lw2j
# Initial revision
#
##########################################################################

use strict;

##### <change_me>
#
# Change this to where you placed the modules.
#
use lib '/afs/cs.cmu.edu/user/lw2j/shared/FracDim/FracDim';
##### </change_me>


require Trim_Flat;

my @x_array = ();
my @y_array = ();


# read all the input data
input_loop:  {
    my $line = <STDIN>;

    defined($line) || last;

    $line =~ s/,/ /go;    # turn commas to spaces
    $line =~ s/\;.*$//go; # treat ; as comment (to end of line)
    $line =~ s/\#.*$//go; # ditto
    $line =~ s/^\s+//o;   # strip leading whitespace
    chomp($line);         # remove trailing whitespace

    # Grab the first two numbers.
    #
    # Translating directly to scalars should allow us to handle
    # various forms, e.g. 4.7E+8 etc, without having to write
    # the regular expressions to do so.
    #
    my ($x,$y) = split /\s+/, $line;

    if (defined($y)) {
        push @x_array, $x;
        push @y_array, $y;
        redo input_loop;
    }
}


# Data read.

my ($new_x_ref, $new_y_ref) = Trim_Flat::trim_flat(\@x_array, \@y_array);

@x_array = @{$new_x_ref};
@y_array = @{$new_y_ref};

die unless ((scalar(@x_array)) == scalar(@y_array));

{
    my $x = shift @x_array;
    my $y = shift @y_array;

    defined($x) || last;

    print "$x $y\n";

    redo;
}

exit 0;


