: # Use perl...
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/bin/perl5 -w
#
# Create an eps graph of the pair-count data, with the
# best-fit line superimposed.
#
#
# All input is derived from STDIN.
#
# The first three lines must each contain one number --
# the slope, the y-intercept, and the correlation.
#
# (Note -- the correlation isn't integral to the plot.
#  It's added because a) it might be good to show on the
#  plot, and b) because it's outputted by the robust
#  linefitter.)
#
# Every subsequent line must contain exactly two
# numbers -- an x coordinate and a y coordinate.
# Both are expected to have already been subjected
# to log_2.
#
# This script doesn't care whether or not the pairs
# have already been trimmed.  They should have been
# for the robust fitter, but one can plot the raw
# pair-count log/log data if desired.
#

use strict;

##### <change_me>
#
# Change this to where you placed the modules.
#
use lib '/afs/cs.cmu.edu/user/lw2j/shared/FracDim/FracDim';
##### </change_me>

use Symbol;
require mktemp;


{
    my $a = <STDIN>;
    my $b = <STDIN>;
    my $r = <STDIN>;

    defined($r) || die;
    chomp($a);
    chomp($b);
    chomp($r);

    $a =~ s/^\s+//o;
    $b =~ s/^\s+//o;
    $r =~ s/^\s+//o;


# We use a temporary file because Gnuplot doesn't take data
# from STDIN as far as I can tell.

    my ($pair_fh, $pair_fn) = mktemp::mktemp();

# It's log data, but we'll use gnuplot's scale to make it
# clear, so we undo the logs.
#

    read_data:  {
        my $line = <STDIN>;

        defined($line) || last read_data;
        chomp($line);
        defined($line) || last read_data;

        $line =~ s/^\s+//o;

        my ($log_radius, $log_count) = split /\s+/, $line;

        defined($log_count) || last read_data;

        print $pair_fh (2 ** ($log_radius)), " ", (2 ** ($log_count)), "\n";

        redo read_data;
    }

    close($pair_fh) || die "Failed to write pair-count tempfile:  $!";


# Assume that Gnuplot is in the path.

    my $gnuplot_fh = gensym;

    if (!open($gnuplot_fh, "|gnuplot")) {
        die "Fatal error -- gnuplot not in path?  $!";
    }

    unlink("temp.eps");

    print $gnuplot_fh "set terminal postscript eps\n";
    print $gnuplot_fh "set output \"temp.eps\"\n";
    print $gnuplot_fh "set title \"Pair-count Plot and Best-Fit Line (Correlation = $r)\"\n";
    print $gnuplot_fh "set xlabel \"Radius (logarithmic)\"\n";
    print $gnuplot_fh "set ylabel \"Pairs (logarithmic)\"\n";
    print $gnuplot_fh "set logscale xy 2\n";
    print $gnuplot_fh "set key under\n";
    print $gnuplot_fh "plot \"$pair_fn\" title \"Pair-Count Data\" with linespoints\n";
    print $gnuplot_fh "replot (2**(($a*log(x)/log(2))+$b)) title \"Linear approximation\"\n";
    print $gnuplot_fh "set terminal postscript eps\n";
    print $gnuplot_fh "set output \"temp.eps\"\n";
    print $gnuplot_fh "replot\n";
    close($gnuplot_fh) || die "Unexpected error -- failed to end gnuplot:  $!";
}

exit 0;

#####################
sub print_usage_and_exit() {
    use File::Basename;

    my $progname = basename($0);

    print "$progname -- Interact with the DiskFracDim.pm module\n";
    print "Usage:\n";
    print "\n";
    print "$progname [-v] [-s] [-q nn] [-r_min nn] [-r_max nn]\n";
    print "          [-r_count] [-intervals]  filename\n";
    print "\n";
    print "Exact parameter semantics are defined by the module.\n";
    print "\n";
    print " -v          Specifies 'verbose'.\n";
    print " -s          Use the slow all-pairs method for C2 -- more\n";
    print "             precise, but perhaps unbearably slow and vile\n";
    print "             in terms of memory consumption.\n";
    print " -q          Box-counting exponent.\n";
    print " -r_min      Minimum radius the module will consider using.\n";
    print " -r_max      Maximum radius it'll try.\n";
    print " -r_count    Maximum number of radii it'll try.\n";
    print " -intervals  The number of intervals for the all-pairs method.\n";
    print "\n";
    print "The options after -s are all specific to box-counting.\n";
    print "\n";
    print "The filename must correspond to a vector data file, with\n";
    print "one equal-dimensioned vector per line, separated by\n";
    print "whitespace or commas.  Comments are to be delineated with\n";
    print "semicolons.\n";
    exit 0;
}
