: # Automagically find perl5 if it's in the path
eval 'exec perl5 -w -S $0 "$@"'
if 0;

# One-off script used to fix the lib lines.
# It requires my 'mktemp' package, for safety reasons
# (if anything goes wrong, we have backups).
#
# Place the modules where you want them, then change to that
# directory and run this script.  It searches for a very
# specific 'use lib' line in the <change_me> block and
# replaces it with 'use lib <insert_cwd>'.
#

use strict;
use Cwd;
use Symbol;

# Just making it explicit.  This is so we can use the temp-file
# generator for safety.
use lib '/afs/cs.cmu.edu/user/lw2j/shared/FracDim/FracDim';

use mktemp;


# Files to fix...
my @fix_files = qw(
                   DiskFracDim.pm
                   Pair_Count.pm
                   Pair_Count.pl
                   Robust_LSFit.pl
                   Trim_Flat.pl
                   fd.pl
                   to_eps.pl
                   to_png.pl
                   );


my $file = undef;
my $dir  = cwd();


print "Library path:  '$dir'\n";

foreach $file (@fix_files) {
    my $ifsym  = gensym();
    my $ofsym  = undef;
    my $ofnam  = undef;

    print "Fixing 'use lib' lines in $file...\n";

    # My packages are small, so they'll easily fit in memory.
    my @data   = ();

    # We'll create a backup copy, just in case anything goes
    # wrong during the rewrite.
    ($ofsym, $ofnam) = mktemp();

    open($ifsym, "$file") || die "Failed to open '$file' (read-only):  $!";
    {
        my $line = undef;
        defined($line = <$ifsym>) || last;
        push @data, $line;

        (print $ofsym $line) || die "Failed to write backup '$ofnam':  $!";
        redo;
    }
    close($ifsym) || die "Failed to close '$file' (read-only):  $!";


    my $ct = scalar @data;
    my $i = 0;
    # Find change_me block (safety).

    for ($i=0; $i < $ct; $i++) {
        ($data[$i] =~ /<change_me>/o) && last;
    }

    ($data[$i] =~ /<change_me>/) || die "No <change_me> block found in '$file'.";
    for ($i++; $i < $ct; $i++) {
        ($data[$i] =~ /<\/change_me>/) && last;
        $data[$i] =~ s:use lib \'[^\']+\':use lib \'$dir\':og;
    }

    ($data[$i] =~ /<\/change_me>/) || die "<change_me> block unterminated in '$file'.";

    # Now, rewrite the file.
    if (!open($ifsym, ">$file")) {
        print "Failed to open '$file' for writing (fixed version):  $!\n";
        print "Revert to backup '$ofnam'.\n";

        # Don't auto-remove the backup!
        forget($ofnam);
        die;
    }

    {
        my $line;

        foreach $line (@data) {
            print $ifsym $line;
        }
    }
    # Close the file.
    if (!close($ifsym)) {
        print "Failed to close '$file' (fixed version):  $!\n";
        print "Revert to backup '$ofnam'.\n";

        # Don't auto-remove the backup!
        forget($ofnam);
        die;
    }
}
