/* File:     diskwrapper.h
 * Purpose:  To redefine the DataWrapper interface with an
 *           on-disk, single-line-buffer, fseek method.
 *           Will not work with STDIN for the obvious 
 *           reasons.  Slow, but uses minimal memory.
 *
 * RCS:
 ************************************************************
 * $Id: DiskWrapper.h,v 1.4 2001/08/23 16:19:14 lw2j Exp $
 * $Log:	DiskWrapper.h,v $
 * Revision 1.4  2001/08/23  16:19:14  lw2j
 * Added the zero_translate option.
 * 
 * Revision 1.3  2001/08/22  17:20:18  lw2j
 * Untabified.
 * 
 * Revision 1.2  2001/08/22  04:27:01  lw2j
 * Added needed 'const' to get_dims / get_count, for consistency
 * with DataWrapper.
 * 
 * Revision 1.1  2001/08/21 03:40:34  lw2j
 * Initial revision
 *
 *
 ************************************************************
 */


#ifndef DISKWRAPPER_H
#define DISKWRAPPER_H

#include <stdio.h>
#include <stdlib.h>
#include "DataWrapper.h"


class DiskWrapper:public DataWrapper {
 public:
  DiskWrapper(FILE* fh_in=NULL):
    fh(fh_in),
    zero_translation(false),
    minima(NULL),
    buf(NULL),
    cardinality(0),
    current_obj_no(0),
    dimensionality(0)
    {
      if (fh_in) {
        load_file(fh_in);
      }
    }

  virtual ~DiskWrapper() { 
    if (buf) {
      delete [] buf;
      buf = NULL;
    }
    if (minima) {
      delete [] minima;
      minima = false;
    }
  };
  

  virtual int load_file(FILE *fh_in);

  /* DiskWrapper does lazy zero translation -- it's all handled
   * during vector retrieval.
   */
  virtual void set_zero_translation(bool new_zero_translation) {
    zero_translation = new_zero_translation;
  }

  virtual bool get_zero_translation() const { 
    return zero_translation; 
  };

  virtual unsigned int get_dims()  const { return dimensionality; };
  virtual unsigned int get_count() const { return cardinality; };
  virtual double* get_vector(unsigned int index) {
    return get_vector_common(index, buf);
  }

  virtual double* get_vector_dynamic(unsigned int index) {
    return get_vector_common(index, NULL);
  }

 protected:
  /* If it's called by get_vector, we'll use 'buf'; otherwise, 
   * we'll use NULL, and that'll be passed to the parent class's
   * find_doubles() method, which will allocate space.
   *
   * We'll do zero-translation, if need be, in this method.
   */

  virtual double* get_vector_common(unsigned int index, double *dst);

  FILE*        fh;
  bool         zero_translation;
  double*      minima;
  double*      buf;             /* Shared buffer for get_vector(). */
  unsigned int cardinality;
  unsigned int current_obj_no;  /* Where are we in the file? */
  unsigned int dimensionality;
};

#endif  /* DISKWRAPPER_H */
