: # Use perl...
eval 'exec perl5 -w -S $0 "$@"'
if 0;

#!/usr/bin/perl5 -w
#
############################################################
# $Id: FDC.pl,v 1.4 2002/01/03 10:58:31 lw2j Exp $
############################################################
# $Log:	FDC.pl,v $
# Revision 1.4  2002/01/03  10:58:31  lw2j
# Now allows CrossCount.
# 
# Revision 1.3  2001/09/03  19:36:11  lw2j
# Edited to include the new DBLayer hacks.
#
# Revision 1.2  2001/08/23  16:35:12  lw2j
# Added zero_translate support.
#
# Revision 1.1  2001/08/22  18:55:45  lw2j
# Initial revision
#
# Revision 1.5  2001/08/22  17:21:29  lw2j
# Untabified (tab=8).
#
# Revision 1.4  2001/08/03  11:22:31  lw2j
# Changed print_args_and_exit to note that r_count does take an
# argument (added 'nn').
#
# Revision 1.3  2001/08/03  11:21:20  lw2j
# Now aware of o_max and s_max options.
#
# Revision 1.2  2001/06/01  15:09:40  lw2j
# Now can use SimpleWrapper to support memory loads.  Ditto -m for
# on-disk files.
#
# Revision 1.1  2001/05/29  18:04:21  lw2j
# Initial revision
#
############################################################
# Forked from fd.pl, version 1.1.
############################################################
# Revision 1.1  2000/11/12  14:41:06  lw2j
# Initial revision
#
# Revision 1.3  2000/10/24  18:00:46  lw2j
# Standardized path.
#
# Revision 1.2  2000/10/03  14:08:01  lw2j
# Added magic perl invoker.
#
# Revision 1.1  2000/07/18  13:27:11  lw2j
# Initial revision
#
############################################################
#
# A simple demo to invoke the Pair_Count package on a
# single file and print the log/log data in an obvious
# format -- one log radius/log count pair per line, separated by
# whitespace.
#
# It accepts all the options that the old fd.pl used to,
# except for verbose (which isn't meaningful anymore,
# because this script prints the log/log by default,
# rather than normally only the FD).
#
use strict;

##### <change_me>
#
# Change this to where you placed the modules.
#
use lib '/afs/cs.cmu.edu/user/lw2j/shared/FracDim/FracDim';
##### </change_me>

use Symbol;


# A unified wrapper module based on earlier, uglier SimpleWrapper and
# DiskWrapper packages.
require Wrapper;
require FDC;

{
    my $in_fh   = gensym;
    my $dw_obj  = undef;

    # parse arguments
    my ($params_ref, $source, $source2, $cross) = parse_arguments();

    if (!defined($source)) {
			if ($cross) {
				# For cross-products, at least one filename must be given.
				print_usage_and_exit();
			}

			$source = new Wrapper(\*STDIN);
			$source->set_buffer($source->{'BUFFER_PACK'});
    }

		if (!defined($source2)) {
			if ($cross) {
				$source2 = new Wrapper(\*STDIN);
				$source2->set_buffer($source2->{'BUFFER_PACK'});
			}
		} else {
			if (!($cross)) {
				# Why two filenames, when we're doing pair-counting?
				print_usage_and_exit();
			}
		}


    $params_ref->{'source'}  = $source;
    $params_ref->{'source2'} = $source2;

    my $pc_obj = new FDC(%{$params_ref});

    my $log_radius_ref = 0;
		my $log_pairs_ref  = 0;

		if ($cross) {
			($log_radius_ref, $log_pairs_ref) = $pc_obj->cross_count();
		} else {
			($log_radius_ref, $log_pairs_ref) = $pc_obj->pair_count();
		}

    # print pairs
    my $ct = scalar @{$log_radius_ref};
    my $i  = 0;

    die unless ((scalar @{$log_pairs_ref}) == $ct);

    for ($i=0; $i < $ct; $i++) {
        my $log_r = $log_radius_ref->[$i];
        my $log_p = $log_pairs_ref->[$i];

        print "$log_r $log_p\n";
    }

    exit 0;
}



#####################
sub print_usage_and_exit() {
    use File::Basename;

    my $progname = basename($0);

    print "$progname -- Interact with the FDC.pm module\n";
    print "Usage:\n";
    print "\n";
    print "Old-style arguments are deprecated, but still implemented.\n";
    print "Setting 'method' to be slow will force use of the quadratic\n";
    print "method from the original Perl module.\n";
    print "\n";
    print "New-style:\n";

    print "$progname \t [--exponent  N]\n";
    print "\t [--base            N]\n";
    print "\t [--radius_min      N]\n";
    print "\t [--radius_max      N]\n";
    print "\t [--radius_count    N]\n";
    print "\t [--singleton_max   N]\n";
    print "\t [--occupancy_max   N]\n";
		print "\t [--db_type         N]\n";
    print "\t [--data_memory   [=N]]\n";
    print "\t [--counter_memory[=N]]\n";
    print "\t [--two_table     [=N]]\n";
    print "\t [--zero_translate[=N]]\n";
    print "\t [--speed   ] \n";
		print "\t [--cross   ] \n";
		print "\t [--pairs   ] \n";
		print "\t [--quad    ] \n";
		print "\t [--min_frac        N]\n";
		print "\t [--max_frac        N]\n";
    print "   [FILENAME [FILENAME]]\n";
    print "\n";
    print "Several of the arguments are merely expanded arguments\n";
    print "prepended by -- for better compliance with standard\n";
    print "style.  'exponent' is a more obvious replacement for 'q'.\n";
    print "\n";
    print "'base' is a new option, and is largely cosmetic; changing\n";
    print "the logarithm base (which this does) merely linearly scales\n";
    print "both axes.\n";
    print "\n";
		print "'db_type' takes a numerical value specifying which database\n";
		print "layer implementation is used to store occupancy counters.\n";
		print "Check the 'driver' binary's help information [-h] or the\n";
		print "Makefile to find out which options have been enabled.\n";
		print "\n";
    print "'data_memory' and 'counter_memory', which take [0|1], toggle\n";
    print "whether or not the original data and the occupancy counters\n";
    print "are stored in memory, respectively.  Both default to 0=off.\n";
    print "\n";
    print "'two_table' toggles whether or not a possibly faster\n";
    print "(but more expensive, storage-wise) algorithm is used when\n";
    print "increasing radii.  It is ignored when the radius multiplier\n";
    print "is not an integer, and defaults to false.\n";
    print "\n";
    print "'zero_translate', which defaults to 1/TRUE, controls whether\n";
    print "or not the data is linearly translated by subtracting the\n";
    print "minima along each axis.\n";
    print "\n";
    print "'speed' is an abbreviation; it turns on the 'memory' options\n";
    print "'two_table'.  May be useful if storage space is not an issue\n";
    print "because either the data is tiny or RAM is plentiful.\n";
		print "\n";
		print "'cross' and 'pairs' are mutually exclusive, denoting cross-\n";
		print "products and pair-counting, respectively.  The first requires\n";
		print "exactly two data sources (if only one filename is given, \n";
		print "STDIN will be used), and computes the products of the\n";
		print "corresponding cells ignoring exponents.  The second is\n";
		print "standard single-source box-counting.";
		print "\n";

		if ($progname =~ /cross/) {
			print "The default is 'cross'.\n"
		} else {
			print "The default is 'pairs'.\n"
		}
		
		print "\nQuad enables the FDC library's quadratic support.  This is\n";
		print "not precisely a drop-in replacement for the 'slow' method of\n";
		print "PairCount due to different options.  However, it is still the\n";
		print "same basic slow algorithm, but in C++.  It supports both pair\n";
		print "and cross-counting.  To prune the radius/count sequence, you\n";
		print "can set the minimum and maximum fractions of pairs that must\n";
		print "be within a given distance for it to be accepted.\n";
		print "\n";

    exit 0;
}


# Returns a reference to a hash table of parameters,
# and a scalar containing the filename.
#
# Always uses @ARGV0.
#
sub parse_arguments() {
    my $fname  = undef;
		my $fname2 = undef;
		my $cross  = undef;

    my %params = ();
    my $arg;
		my $base   = basename($0);

		$cross = ($base =~ /cross/) ? 1 : 0;

    while (defined($arg = $ARGV[0]) && ($arg =~ /^-/)) {
			$arg = shift @ARGV;

			if ($arg =~ /=(\d+)$/o) {
				unshift @ARGV, $1;
				$arg =~ s/=.*$//o;
			}

			if ($arg eq '-s') {
				$params{'method'}  = 'slow';
			} elsif ($arg eq '-m') {
				$params{'data_memory'} = 1;
			} elsif (($arg eq '-q')       ||  #old-style
							 ($arg eq '-r_min')   ||
							 ($arg eq '-r_max')   ||
							 ($arg eq '-r_count') ||
							 ($arg eq '-s_max') ||
							 ($arg eq '-o_max') ||
							 ($arg eq '-intervals')) {

				$arg =~ s/^-//;
				my $val = shift @ARGV;

				defined($val) || die "Failed to supply value for -$arg";

				if ($val ne 'undef') {
					$params{$arg} = $val;
				} else {
					$params{$arg} = undef;
				}
			} elsif ($arg eq '--speed') {             # new-style, 0 arguments
				$arg =~ s/^--//go;
				$params{$arg} = 1;
			} elsif ($arg eq '--cross') {
				$cross = 1;
			}	elsif ($arg eq '--pairs') {
				$cross = 0;
			} elsif (($arg eq '--exponent')      ||   # new-style, 1 argument
							 ($arg eq '--base')          ||
							 ($arg eq '--radius_min')    ||
							 ($arg eq '--radius_max')    ||
							 ($arg eq '--radius_count')  ||
							 ($arg eq '--singleton_max') ||
							 ($arg eq '--occupancy_max') ||
							 ($arg eq '--db_type')       ||
							 ($arg eq '--min_frac')      ||
							 ($arg eq '--max_frac')) {

				$arg =~ s/^--//;
				my $val = shift @ARGV;

				defined($val) || die "Failed to supply value for -$arg";

				if ($val ne 'undef') {
					$params{$arg} = $val;
				} else {
					$params{$arg} = undef;
				}
			} elsif (($arg eq '--data_memory') ||     # new-style, 0 or 1 args
							 ($arg eq '--counter_memory') ||
							 ($arg eq '--two_table') ||
							 ($arg eq '--zero_translate') ||
							 ($arg eq '--quad')) {
				my $nextarg = $ARGV[0];

				$arg =~ s/^--//;
				if ((!defined($nextarg)) ||
						($nextarg eq '--')   ||
						($nextarg =~ /^-/)) {
					# Next item is NOT a value for this option; and
					# these default to 1 if option given but no value.
					$params{$arg} = 1;
				} else {
					# Value given -- use and consume.
					shift @ARGV;
					$params{$arg} = $nextarg;
				}
			} elsif ($arg eq '--') {
				last;
			} else {
				print_usage_and_exit();
			}
    }
    $fname   = shift @ARGV;

		# Should be undefined, if $cross==0.
    $fname2   = shift @ARGV;

    return (\%params, $fname, $fname2, $cross);
}
