#!/usr/bin/perl

use strict;
use CGI;

my $q = new CGI;
my ($numpart, $pass);
my $remote_host = $ENV{'REMOTE_ADDR'};
my $count;
sleep(3);

$numpart = $q->param('numpart');
$pass = $q->param('sessionname');

print
    $q->header(),
    $q->start_html(-title=>'Enter participant information'),
    $q->h1("Please fill in information for the $numpart participants."),
    $q->startform('POST', 'getclients.pl'), 
    "<table border=0 cellspacing=10>";

for ($count = 0; $count < $numpart; $count++) {
    print
        "<tr><td>", $q->hr(), "</td></tr>",
        "<tr>",
        "<td align=right>User name</td>",
        "<td align=left>", $q->textfield("clientname$count", '', 50, 80),
            "</td>",
        "</tr>",

        "<tr>",
        "<td align=right>IP address</td>",
        "<td align=left>", $q->textfield("hostaddress$count", '', 50, 80),
            "</td>",
        "</tr>",

        "<tr>",
        "<td align=right>IP multicast capable?</td>",
        "<td align=left>",
            $q->radio_group("IPMulticast$count", ['yes', 'no'], 'no', 'true'),
            "</td>",
        "</tr>",

        "<tr>",
        "<td align=right>Application/platform</td>",
        "<td align=left>",
            $q->popup_menu("VCprot$count",
                           ['vic/SDR', 'NetMeeting',
                            'receive-only handheld (vic)'],
                           'vic/SDR'),
            "</td>",
        "</tr>",

        "<tr>",
        "<td align=right>Using whiteboard (wbd)?</td>",
        "<td align=left>",
            $q->radio_group("WBD$count", ['yes', 'no'], 'no', 'true'),
            "</td>",
        "</tr>",
}

print "</table>";

print $q->hr();
print "<h2>Additional services</h2><p>";
print $q->checkbox('movieservice', 1, 'yes', 'Movie Service'), "<br>";
print "Movie name ", $q->textfield("moviename", '', 50, 80);

print "<p>";
print $q->hidden('numclients', $numpart), $q->submit('Execute setup');

$q->endform,
$q->end_html();

exit 0;


