#include <iostream.h>

#include "Network.h"
#include "TimeSyn.h"
#include "TransmissionTable.h"
#include "BufferQueue.h"
#include "Parser.h"

const int BUFFER_SIZE = 5000;

int main(int argc, char** argv) {

  double reference_time;
  long time_base;
  int pid = 0;
  int fd[2];

  char buf;
  char long_buf[BUFFER_SIZE];

  char* monitorAddress = NULL;
  int monitorPort = -1;
  char* timeServer = NULL;

  int monitor = 0;

  // Extract viewer parameters
  int indexArg = 1;
  while (indexArg < argc) {
    if (strcmp(argv[indexArg], "-t") == 0) {
      timeServer = argv[indexArg + 1];
      indexArg += 2;
    }
    else if (strcmp(argv[indexArg], "-m") == 0) {
      monitorAddress = argv[indexArg + 1];
      indexArg += 2;
    }
    else if (strcmp(argv[indexArg], "-p") == 0) {
      monitorPort = atoi(argv[indexArg + 1]);
      indexArg += 2;
    }
    else
      break;
  }

  if (timeServer == NULL) {
    perror("No time server specified.");
    exit(1);
  }

  int sockfd = createSocketID();

  time_syn(timeServer, sockfd, reference_time, time_base);

  
  cout.setf(ios::fixed, ios::floatfield);
  cout<<reference_time<<"    "<<time_base<<endl;

  BufferQueue* sendBuffer = NULL;
  TransmissionTable* table = NULL;

  if (monitorAddress != NULL && monitorPort != -1)
    monitor = 1;

  sem_init(&monitorLock, 0, 1);
  
  if (monitor) {
    sendBuffer = new BufferQueue(128);
    table = new TransmissionTable();
    sem_init(&monitorLock, 0, 0);
    initializeNetworkComponents(sockfd, monitorAddress, monitorPort, 
				sendBuffer, table);
    
    Packet p;
    createInitPacket(p);
    sendBuffer->enqueue(p);
  }

  sleep(5);

  sem_wait(&monitorLock);

  Parser parser(sendBuffer, table);

  pipe(fd);
  pid = fork();
  if (!pid) {
    close(fd[0]);
    dup2(fd[1], 1);
    
    char command[100];
    char space = ' ';
    strcpy((char*)command, argv[indexArg]);
    for (int i = indexArg + 1; i < argc; i++) {
      strncat((char*)command, (char*)&space, 1);
      strcat((char*)command, argv[i]);
    }
    
    system(command);
    close(1);
    close(fd[1]);
  }
  else {
    close(fd[1]);
    
    int index = 0;
    int rtn;
    
    rtn = read(fd[0], &buf, 1);
    
    while (rtn > 0) {
      
      long_buf[index] = buf;
      index ++;
      
      if (buf == '\n' || index == BUFFER_SIZE) {
	long_buf[index++] = '\0';
	index = 0;
	// Process it
	char* pos = NULL;
	
	if ( (long_buf[0] >= char('0') && long_buf[0] <= char('9')) ||
	     long_buf[0] == '-') {
	  pos = (char*)long_buf;
	}
	else if ( long_buf[0] == ' ' &&
		  ((long_buf[1] >= char('0') && long_buf[1] <= char('9'))
		   ||
                   long_buf[1] == '-') ) {
	  pos = (char*)(long_buf + 1);
	}
	
	if (pos != NULL) {	 
	  char* duplicate = strdup(long_buf);
	  char* timeStr = strtok(duplicate, ":");
	  
	  if (timeStr[0] == ' ')
	    timeStr = (char*)(timeStr + 1);
	  
	  long time_diff = atol(timeStr) - time_base;
	  double global = reference_time + (double)time_diff / 1000;
	  
	  char* origPos = strstr(long_buf, ":");

    	  cout.setf(ios::fixed, ios::floatfield);
	  cout<<global<<origPos;

	  // parse the string ONLY AFTER print out as
	  //  it may modify it - tungfai  see strtok()
	  if (monitor && buf == '\n')
	    parser.readString(global, origPos);
	  
	}
	else {
	  cout<<long_buf;

	  if (monitor)
	    parser.readString(-1, long_buf);

	}
      }
      rtn = read(fd[0], &buf, 1);
      cout << ".";
      flush(cout); // yhchu XXX
    }
    
    close(fd[0]);
    if (monitor) {
      Packet endPacket;
      createTerminatePacket(endPacket);
      sendBuffer->enqueue(endPacket);
    }

  }
  exit(0);
}
