#ifndef VRTABLE_H_
#define VRTABLE_H_

#include <assert.h>

struct VRTableEntry {
  int dest;
  int nextHop;
  int cost;
  bool deadFlag;
};

class VRTable {
 public:
  // contain Array of VRTableEntry
  VRTable(int initSize);
  ~VRTable();
  // resize table to new size when needed
  void resizeTable(int newSize);
  // returns the number of updates
  // returns pointer to a boolean array of size 'currentSize' where a true
  // means new updates is stored at that index in newTable
  int compareTable(VRTable* newTable, bool* changedArray);
  VRTableEntry getEntryByIndex(int index);
  void setEntryByIndex(int index, int dest, int nextHop, int cost, bool deadFlog);
  int getSize();
 private:
  int currentSize;
  void initVRTable(int startIndex);
 protected:
  VRTableEntry* vrtTable;
};

#endif






