#include "VRTable.h"

VRTable::VRTable(int initSize) {
  this->currentSize = initSize;
  this->vrtTable = new VRTableEntry[initSize];
  initVRTable(0);
}

VRTable::~VRTable() {
  delete [] this->vrtTable;
}

// initialize table starting at the startIndex
void VRTable::initVRTable(int startIndex) {
  for (int i = startIndex; i < this->currentSize; i++) { // initialize value
    vrtTable[i].dest = -1;
    vrtTable[i].nextHop = -1;
    vrtTable[i].cost = -1;
    vrtTable[i].deadFlag = false;
  }
}

void VRTable::resizeTable(int newSize) {
  VRTableEntry *newTable = new VRTableEntry[newSize];
  for (int i = 0; i < this->currentSize; i++) {
    newTable[i].dest = this->vrtTable[i].dest;
    newTable[i].nextHop = this->vrtTable[i].nextHop;
    newTable[i].cost = this->vrtTable[i].cost;
    newTable[i].deadFlag = this->vrtTable[i].deadFlag;
  }
  delete [] this->vrtTable;
  this->vrtTable = newTable;
  int oldSize = this->currentSize;
  this->currentSize = newSize;
  // important:  have to call this function after the new table and new
  // size has been assigned
  // init the rest of the new table
  initVRTable(oldSize);
}

// returns numbers of updates
// return -1 if no difference between two tables
// caller provide storage for changeArray, and responsible to free the space
int VRTable::compareTable(VRTable* newTable, bool* changeArray) {
  int count = 0;
  for (int i = 0; i < this->currentSize; i++) {
    assert (this->vrtTable[i].dest == newTable->vrtTable[i].dest);// something majorly wrong
    if (this->vrtTable[i].dest != newTable->vrtTable[i].dest ||
	this->vrtTable[i].nextHop != newTable->vrtTable[i].nextHop ||
	this->vrtTable[i].cost != newTable->vrtTable[i].cost ||
	this->vrtTable[i].deadFlag != newTable->vrtTable[i].deadFlag) {
      changeArray[i] = true;
      count++;
    }
    else
      changeArray[i] = false;
  }
  // new Entries are added
  if (this->getSize() <  newTable->getSize()) {
    for (int i = this->getSize(); i < newTable->getSize(); i++) {
      changeArray[i] = true;
      count++;
    }
  }
  return count;
}

int VRTable::getSize() {
  return this->currentSize;
}

VRTableEntry VRTable::getEntryByIndex (int index) {
  assert (index < this->currentSize);
  return this->vrtTable[index];
}

void VRTable::setEntryByIndex (int index, int destSource, int nexthop, int c, bool dead) {
  assert (index < this->currentSize);
  this->vrtTable[index].dest = destSource;
  this->vrtTable[index].nextHop = nexthop;
  this->vrtTable[index].cost = c;
  this->vrtTable[index].deadFlag = dead;
}

