
#include "TransmissionTable.h"

const int MAX_SEQ = 128;

TransmissionTable::TransmissionTable() {
  sem_init(&lock, 0, 1);
  timeout = -1;
  retransmit = -1;
  seqNum = 0;
  recvSeq = 0;
}

void TransmissionTable::setTimeoutValue(short value) {
  sem_wait(&lock);
  timeout = value;
  sem_post(&lock);
}

void TransmissionTable::setRetransmitCount(short value) {
  sem_wait(&lock);
  retransmit = value;
  sem_post(&lock);
}

void TransmissionTable::incrementSeqNum() {
  sem_wait(&lock);
  seqNum = (seqNum + 1) % MAX_SEQ;
  sem_post(&lock);
}

short TransmissionTable::getTimeoutValue() {
  sem_wait(&lock);
  short rtn = timeout;
  sem_post(&lock);

  return rtn;
}

short TransmissionTable::getRetransmitCount() {
  sem_wait(&lock);
  short rtn = retransmit;
  sem_post(&lock);

  return rtn;
}

void TransmissionTable::resetRetransmitCount() {
  sem_wait(&lock);
  retransmit = 0;
  sem_post(&lock);
}

short TransmissionTable::getSeqNum() {
  sem_wait(&lock);
  short rtn = seqNum;
  sem_post(&lock);
  return rtn;
}

void TransmissionTable::setRecvSeqNum(short value) {
  sem_wait(&lock);
  recvSeq = value;
  sem_post(&lock);
}

short TransmissionTable::getRecvSeqNum() {
  sem_wait(&lock);
  short rtn = recvSeq;
  sem_post(&lock);
  return rtn;
}
