
#include "TimeSyn.h"
#include <iostream.h>

const int PACKET_SIZE = 48;
const int SERVER_PORT = 123;
const unsigned int TIME_DIFF = 2208988800;
const int PACKETNUM = 1;

char* time_server = 0;

void *timeSyn_sendfunc(char* arg) {
  
  int sockfd;
  int *recv_count;
  struct sockaddr_in serv_addr;
  int servaddrlen = sizeof(serv_addr);

  memcpy((char*)&sockfd, (char*)arg, sizeof(int));
  memcpy((char*)&recv_count, (char*)(arg + sizeof(int)), sizeof(int));
  memcpy((char*)&serv_addr, (char*)(arg + sizeof(int) + sizeof(int)),
	 sizeof(struct sockaddr_in));

  while (*recv_count < PACKETNUM) {

    char packet[PACKET_SIZE];
    bzero(packet, PACKET_SIZE);
    
    // Compose the packet
    char li_vn_mode = 0x23;
    struct timeval tp;
    gettimeofday(&tp, NULL);
    unsigned int org_sec = (unsigned int)tp.tv_sec + TIME_DIFF;
    double org_frac = (double)tp.tv_usec / 1000000;
    unsigned int org_frac_bin = fraction_to_binary(org_frac);

    org_sec = htonl(org_sec);
    org_frac_bin = htonl(org_frac_bin);
    
    char org_sec_array[sizeof(unsigned int)];
    char org_frac_bin_array[sizeof(unsigned int)];
    
    memcpy((char*)org_sec_array, (char*)&org_sec, sizeof(unsigned int));
    memcpy((char*)org_frac_bin_array, (char*)&org_frac_bin, sizeof(unsigned int));
    
    // Put into the packet
    memcpy(packet, (char*)&li_vn_mode, sizeof(char));
    memcpy((char*)(packet + 40), (char*)(org_sec_array + sizeof(unsigned int) - 4), 4);
    memcpy((char*)(packet + 44), (char*)(org_frac_bin_array + sizeof(unsigned int) - 4), 4);
    
    // Send to server
    if (sendto(sockfd, packet, PACKET_SIZE, 0, (const struct sockaddr*)&serv_addr, 
	       servaddrlen) != PACKET_SIZE) {
      perror("client: sendto");  //print out error when occurs
      exit(1);                   //exit with error
    }

    sleep(1);


  }
  
  return NULL;

}


void *timeSyn_recvfunc(char* arg) {

  int sockfd;
  int *recv_count;
  int number_bytes = 0;
  double *ref_time;
  struct timeval* tp;

  double accum_delay = 0.0;

  memcpy((char*)&sockfd, (char*)arg, sizeof(int));
  memcpy((char*)&recv_count, (char*)(arg + sizeof(int)), sizeof(int));
  memcpy((char*)&ref_time, (char*)(arg + sizeof(int) + sizeof(int)), sizeof(double));
  memcpy((char*)&tp, (char*)(arg + sizeof(int) + sizeof(int) + sizeof(double)),
	 sizeof(struct timeval));


  while (*recv_count < PACKETNUM) {
    char packet[PACKET_SIZE];
    bzero(packet, PACKET_SIZE);  

    // Waiting for request_ack message
    struct sockaddr_in sock;
    socklen_t socklen = sizeof(sock);
    number_bytes = recvfrom(sockfd, packet, PACKET_SIZE, 0, 
			    (struct sockaddr *)&sock, &socklen);
    gettimeofday(tp, NULL);

    unsigned int dest_sec = (unsigned int)tp->tv_sec + TIME_DIFF;
    double dest_frac = (double)tp->tv_usec / 1000000;
    
    if (number_bytes < 0) {
      perror("client: recvfrom");
      exit(1);
    }
    
    if (number_bytes != PACKET_SIZE) {
      perror("client: recvfrom bytes");
      exit(1);
    }
    
    *recv_count += 1;

    unsigned int org_sec, org_frac_bin;
    double org_frac;
    unsigned int rev_sec, rev_frac_bin;
    double rev_frac;
    unsigned int tran_sec, tran_frac_bin;
    double tran_frac;
    
    // Extract the timestamps
    memcpy((char*)&org_sec, (char*)(packet + 24), 4);
    memcpy((char*)&org_frac_bin, (char*)(packet + 28), 4);
    memcpy((char*)&rev_sec, (char*)(packet + 32), 4);
    memcpy((char*)&rev_frac_bin, (char*)(packet + 36), 4);
    memcpy((char*)&tran_sec, (char*)(packet + 40), 4);
    memcpy((char*)&tran_frac_bin, (char*)(packet + 44), 4);

    org_sec = ntohl(org_sec);
    org_frac_bin = ntohl(org_frac_bin);
    rev_sec = ntohl(rev_sec);
    rev_frac_bin = ntohl(rev_frac_bin);
    tran_sec = ntohl(tran_sec);
    tran_frac_bin = ntohl(tran_frac_bin);
    
    org_frac = binary_to_fraction(org_frac_bin);
    rev_frac = binary_to_fraction(rev_frac_bin);
    tran_frac = binary_to_fraction(tran_frac_bin);
        
    double org_time = (double)org_sec + org_frac;
    double rev_time = (double)rev_sec + rev_frac;
    double tran_time = (double)tran_sec + tran_frac;
    double dest_time = (double)dest_sec + dest_frac;
    
    double r_delay = ((dest_time - org_time) - (rev_time - tran_time));
    //double r_delay = ((dest_time - org_time) - (tran_time - rev_time));
    double delay = r_delay / 2;

    accum_delay += delay;

    //cout.setf(ios::fixed, ios::floatfield);

    if (*recv_count == PACKETNUM) {
      *ref_time = tran_time + (delay / *recv_count);
    }
      
  }

  return NULL;
}


void time_syn(char* hostname, int sockfd, double& ref_time, long& base) {

  int* recv_count = new int;
  *recv_count = 0;

  pthread_t recvThread;
  pthread_t sendThread;

  char* send_arg = NULL;
  char* recv_arg = NULL;

  double *ref = new double;
  struct timeval* basetp = new struct timeval;
  
  struct sockaddr_in serv_addr;
  struct hostent* server;
  
  time_server = hostname;

  // Pre-set the server parameters
  bzero((char *)&serv_addr, sizeof(serv_addr));
  
  if ( (server = gethostbyname(hostname)) == NULL ) {
    fprintf(stderr, "Cannot get address for host %s\n", hostname);
    exit(1);
  }                                                                                            

  memcpy(&(serv_addr.sin_addr.s_addr), server->h_addr, server->h_length);  
  
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(SERVER_PORT);
  

  send_arg = new char[sizeof(int) + sizeof(int) + sizeof(struct sockaddr)];
  memcpy((char*)send_arg, (char*)&sockfd, sizeof(int));
  memcpy((char*)(send_arg + sizeof(int)), (char*)&recv_count, sizeof(int));
  memcpy((char*)(send_arg + sizeof(int) + sizeof(int)), (char*)&serv_addr, sizeof(struct sockaddr));

  recv_arg = new char[sizeof(int) + sizeof(int) + sizeof(double) + sizeof(struct timeval)];
  memcpy((char*)recv_arg, (char*)&sockfd, sizeof(int));
  memcpy((char*)(recv_arg + sizeof(int)), (char*)&recv_count, sizeof(int));
  memcpy((char*)(recv_arg + sizeof(int) + sizeof(int)), (char*)&ref, sizeof(double));
  memcpy((char*)(recv_arg + sizeof(int) + sizeof(int) + sizeof(double)),
	 (char*)&basetp, sizeof(struct timeval));


  pthread_create(&recvThread, NULL, timeSyn_recvfunc, (void*)recv_arg);
  pthread_create(&sendThread, NULL, timeSyn_sendfunc, (void*)send_arg);

  pthread_join(recvThread, NULL);
  pthread_join(sendThread, NULL);

  ref_time = *ref;
  base = (long)(basetp->tv_sec * 1000 + (double)basetp->tv_usec / 1000);


}
