#ifndef SPANNING_TREE_TABLE_ENTRY_H
#define SPANNING_TREE_TABLE_ENTRY_H

#include <assert.h>

struct SpanningTreeTablePacketEntry {
  int numChildren;
  int forwardHost;
  int* children;
};


class SpanningTreeTableEntry {
 public:
  // initialize childArray to size of initChildSize;
  SpanningTreeTableEntry(int srcID, int initChildSize);
  ~SpanningTreeTableEntry();
  // mark index child id true in the child array if local host needed to forward
  // information to that child
  void markChild(int childID);
  int getChildArraySize();
  bool equals(SpanningTreeTableEntry *entry);
  int getSrcID();
  void resizeChildArray(int newSize);
  bool isChild(int index);
  int numChildren();
 private:
  int srcID;
  int curSize;
  int numChild;
 protected:
  bool * childrenArray;

};
#endif
