#include "SpanningTreeTableEntry.h"

SpanningTreeTableEntry::SpanningTreeTableEntry(int srcid, int initChildSize) {
  this->childrenArray = new bool[initChildSize];
  this->srcID = srcid;
  this->curSize = initChildSize;
  for (int i = 0; i < initChildSize; i++)
    this->childrenArray[i] = false;
  numChild = 0;
}

SpanningTreeTableEntry::~SpanningTreeTableEntry() {
  delete [] childrenArray;
}

void SpanningTreeTableEntry::markChild(int childID) {
  if (childID >= this->curSize) 
    this->resizeChildArray(childID+1);
  this->childrenArray[childID] = true;
  this->numChild++;
}

void SpanningTreeTableEntry::resizeChildArray(int newSize) {
  bool *newChildArray = new bool[newSize];
  for (int i = 0; i < this->curSize; i++) 
    newChildArray[i] = childrenArray[i];
  for (int i = this->curSize; i < newSize; i++) 
    newChildArray[i] = false;
  delete [] childrenArray;
  childrenArray = newChildArray;
  curSize = newSize;
}

int SpanningTreeTableEntry::getChildArraySize() {
  return curSize;
}

int SpanningTreeTableEntry::getSrcID() {
  return srcID;
}

bool SpanningTreeTableEntry::equals(SpanningTreeTableEntry *entry) {
  assert(this->getSrcID() == entry->getSrcID());
  /*  0906 bug fix - when a table is resized, childArraySize increased also
      we shouldn't take consideration of ChildArraySize at entry level 
      because if table is resized, all entries will return false with statement
      below, which is incorrect
  */
  /*
  if (this->getChildArraySize() != entry->getChildArraySize() ||
      this->numChildren() != entry->numChildren())
    return false; // number of children is different
  */
  // 0906 correct way
  if (this->numChildren() != entry->numChildren())
    return false; // number of children is different 
  for (int i = 0; i < this->getChildArraySize(); i++) 
    if (this->childrenArray[i] != entry->childrenArray[i])
      return false;
  return true;
}

bool SpanningTreeTableEntry::isChild(int index) {
  return this->childrenArray[index];
}

int SpanningTreeTableEntry::numChildren() {
  return numChild;
}
