#include "SpanningTreeTable.h"

SpanningTreeTable::SpanningTreeTable(int size) {
  this->currentSize = size;
  this->table = new (SpanningTreeTableEntry*)[size];
  for (int i = 0; i < size; i++)
    this->table[i] = NULL;
}

SpanningTreeTable::~SpanningTreeTable() {
  for (int i = 0; i < this->currentSize; i++)
    if (table[i] != NULL)
      delete table[i];
  delete [] table;
}

// actually, this function shouldn't be used
void SpanningTreeTable::resize(int newSize) {
  
  SpanningTreeTableEntry **newTable = new (SpanningTreeTableEntry*)[newSize];

  for (int i = 0; i < this->currentSize; i++) {// resize all children
    this->table[i]->resizeChildArray(newSize);
    newTable[i] = table[i];
    this->table[i] = NULL;
  }
  for (int i = this->currentSize; i < newSize; i ++)
    newTable[i] = NULL;
  
  delete [] this->table;
  this->table = newTable;
  this->currentSize = newSize;
  
}

int SpanningTreeTable::getSize() {
  return this->currentSize;
}

// caller needs to allocate space for the change array 
int SpanningTreeTable::compareTable(SpanningTreeTable* newTable, bool* changeArray){
  int count = 0;
  for (int i = 0; i < this->currentSize; i++) {
    if (this->table[i]->equals(newTable->getEntryByIndex(i)) == false) {
      count++;
      changeArray[i] = true;
    }
    else
      changeArray[i] = false;
  }
  for (int i = this->currentSize; i < newTable->getSize(); i++) {
    count++;
    changeArray[i] = true;
  }
  return count;
}

SpanningTreeTableEntry* SpanningTreeTable::getEntryByIndex (int index) {
  assert (index < this->currentSize);
  return table[index];
}

void SpanningTreeTable::insertEntryToTable(int index, SpanningTreeTableEntry* entry) {
  // if old entry exist, clean up memory
  assert(table[index] == NULL);
  table[index] = entry;
}

