#ifndef PARSER_H_
#define PARSER_H_

#include <string.h>

#include "BufferQueue.h"
#include "TransmissionTable.h"
#include "Network.h"
#include "AddrMap.h"
#include "VRTable.h"
#include "SpanningTreeTable.h"

const char JOIN = 0;
const char DEAD = 1;
const char ADD_NBR_RESPONSE = 2;
const char DELAY = 3;
const char INTENT_TO_CANCEL = 4;
const char CANCEL_NEIGHBOR = 5;
const char VRTENTRY = 6;
const char SPANNINGTREE = 7;

class Parser {
 public:
  Parser(BufferQueue* buffer, TransmissionTable* t);

  void readString(double time, char* str);

 private:
  int inetAddrToInt(char* host);
  void createPacket(double time, int curhost, int targethost, int delay, char type, Packet& packet);
  void createPacket(double time, int curhost, int vrtSize, VRTableEntry entry[], int size, Packet& packet);
  void createPacket(double time, int curhost, int vrtSize, SpanningTreeTablePacketEntry entry[], int size, Packet& packet);

  double changeDoubleEndian(double orig);

  BufferQueue* sendBuffer;
  TransmissionTable* table;
  int currentHost;

  double saved_time;
  AddrMap* addrMap;
  //  for VRT
  bool VRTStart;
  VRTable* curVRTable;
  VRTable* newVRTable;
  int numChild;
  int forwardSource;
  SpanningTreeTable* curSpanningTreeTable;
  SpanningTreeTable* newSpanningTreeTable;
  int vrtSize;
  double vrtTime;
};

#endif

