
#include "Parser.h"


Parser::Parser(BufferQueue* buffer, TransmissionTable* t) {
  sendBuffer = buffer;
  table = t;
  addrMap = NULL;
  VRTStart = false;
  curVRTable = NULL;
  newVRTable = NULL;
  numChild = -1;
  forwardSource = -1;
  curSpanningTreeTable = NULL;
  newSpanningTreeTable = NULL;
  vrtSize = -1;
  vrtTime = -1;
}


void Parser::readString(double time, char* str) {

  char* pos;
  Packet packet;
  if (time != -1) // TODO, fix after Sanjay's done with his code
    saved_time = time;

  if ((pos = strstr(str, "HOSTNAME")) != NULL) {
    int nameLen = strlen(str) - 10;
    char* current = new char[nameLen + 1];
    strncpy(current, (char*)(str + 9), nameLen);
    current[nameLen] = '\0';
    currentHost = inetAddrToInt(current);
    delete[] current;
  } 
  else if (((pos = strstr(str, "JOIN:")) != NULL) &&
	   strstr(str, "ShortListed JOIN:") == NULL &&
	   strstr(str, "Num Shortlisted JOIN:") == NULL) {
    // send time, currentHost
    // cout<<"--- SEND: time: "<<time<<"  "<<" currenthost: "<<currentHost<<endl;
    createPacket(time, currentHost, -1, -1, JOIN, packet);
    sendBuffer->enqueue(packet);
  }
  else if ((pos = strstr(str, "DEAD")) != NULL) {
    char* start = strtok(str, " ");
    start = strtok(NULL, " ");
    start = strtok(NULL, " ");

    int deadHostInet = inetAddrToInt(start);
    // cout<<"--- SEND: time: "<<time<<"  "<<"  currenthost: "<<currentHost<<"  deadhost: "<<deadHostInet<<endl;
    createPacket(time, currentHost, deadHostInet, -1, DEAD, packet);
    sendBuffer->enqueue(packet);
  }
  else if ((pos = strstr(str, "ADD_NBR_RESPONSE")) != NULL) {
    char* strPos = strtok(str, " ");
    for (int i = 0; i < 7; i++) 
      strPos = strtok(NULL, " ");

    if (strPos[strlen(strPos) - 1] == '\n')
      strPos[strlen(strPos) - 1] = '\0';

    int host = inetAddrToInt(strPos);
    // cout<<"--- SEND: time: "<<time<<"  "<<"  currenthost: "<<currentHost<<"  target: "<<host<<endl;
    createPacket(time, currentHost, host, -1, ADD_NBR_RESPONSE, packet);
    sendBuffer->enqueue(packet);
  }
  else if ((pos = strstr(str, "one-way delay")) != NULL) {
    char* strPos = strtok(pos, " ");
    for (int i = 0; i < 4; i++)
      strPos = strtok(NULL, " ");

    int host = inetAddrToInt(strPos);
    strPos = strtok(NULL, " ");
    strPos = strtok(NULL, " ");

    int delay = atoi(strPos);
    
    // cout<<"--- SEND: time: "<<saved_time<<"  "<<"  currenthost: "<<currentHost<<"  target: "<<host<<"  one-way delay: "<<delay<<endl;

    createPacket(saved_time, currentHost, host, delay, DELAY, packet);
    sendBuffer->enqueue(packet);

  }
  else if ((pos = strstr(str, "INTENT_TO_CANCEL")) != NULL) {
    if ((pos = strstr(str, "Send")) != NULL) {
      char* strPos = strtok(str, " ");
      for (int i = 0; i < 7; i++)
	strPos = strtok(NULL, " ");

      if (strPos[strlen(strPos) - 1] == '\n')
	strPos[strlen(strPos) - 1] = '\0';      
      int host = inetAddrToInt(strPos);
      
      // cout<<"--- SEND: time: "<<time<<"  "<<"  currenthost; "<<currentHost<<"  target: "<<host<<endl;
      createPacket(time, currentHost, host, -1, INTENT_TO_CANCEL, packet);
      sendBuffer->enqueue(packet);
    }
  }
  else if ((pos = strstr(str, "CANCEL_NBR")) != NULL) {
    if ((pos = strstr(str, "receive")) != NULL) {
      char* strPos = strtok(str, " ");
      for (int i = 0; i < 7; i++)
	strPos = strtok(NULL, " ");

      if (strPos[strlen(strPos) - 1] == '\n')
	strPos[strlen(strPos) - 1] = '\0';

      int host = inetAddrToInt(strPos);
      
      // cout<<"--- SEND: time: "<<time<<"  "<<"  currenthost; "<<currentHost<<"  target: "<<host<<endl;

      createPacket(time, currentHost, host, -1, CANCEL_NEIGHBOR, packet);
      sendBuffer->enqueue(packet);
    }
  }
  /*
old format:
    3200064954.381125:VRT Begin 1
 Addr -2122316732 Name namur.cs.ualberta.ca:
 Addr: -2122316732 Name namur.cs.ualberta.ca LCSN = 827 Time = -1061290988 PDR = 0.00 PD = 0 RD = 0 PBR = 1 PBA = 1 RB = 1 NH = 0.0.0.0 Num Delay Probes = 0 LDProbeTime = -3 Num BW Probes = 0 LBWProbeTime = -3 numChildren = 0 DeadFlg = 0
 Path:  (len = 0)
 Children : 
 VRT End

new format
3226615269.884551:VRT Begin 3
 Addr: -2147300046 Name litespeed.cmcl.cs.cmu.edu LCSN = 848 Time = -280779261 PDR = -1.00 PD = -1 RD = 0 PBR = -1 PBA = 1700 RB = 1700 NH = 255.255.255.255 Num Delay Probes = 0 LDProbeTime = -1 Num BW Probes = 0 LBWProbeTime = -1 numChildren = 0 DeadFlg = 0
 MyPath:  (len = 0)
 Children : 
 VRT End

  */

  else if ((pos = strstr(str, "VRT Begin")) != NULL) {
    VRTStart = true;  
    this->vrtTime = time;
    strtok(str, " ");
    strtok(NULL, " ");
    this->vrtSize = atoi(strtok(NULL, " "));
    cout << this->vrtSize << endl;
    if (addrMap == NULL)
      addrMap = new AddrMap(vrtSize ,5);
    newVRTable = new VRTable(vrtSize);
    newSpanningTreeTable = new SpanningTreeTable(vrtSize);
  }
  else if (VRTStart && (pos = strstr(str, "Addr:")) != NULL) {
    int dest = 0; 
    bool destFound = false;

    int nextHop = 0; 
    bool nextHopFound = false;

    int cost = 0; 
    bool costFound = false;

    bool dead = true; 
    bool deadFound = false;

    bool numChildrenFound = false;

    char* strPos = strtok(str, " ");
    // fprintf(stderr, "%s\n", str);
    while ((strPos = strtok(NULL, " ")) != NULL) {
	// fprintf(stderr, "Tok = %s ", strPos);
	
	if (strcmp(strPos, "Name") == 0) {
	    char *tok = strtok(NULL, " ");

	    dest = inetAddrToInt(tok);
	    destFound = true;
	    this->forwardSource = dest;
	    addrMap->insertItem(dest);

	    // fprintf(stderr, "Name = %s ", tok);
	    continue;
	}
	
	if (strcmp(strPos, "PD") == 0) {
	    strtok(NULL, " ");
	    char *tok = strtok(NULL, " ");

	    cost = atoi(tok);
	    costFound = true;

	    // fprintf(stderr, "Cost = %d ", cost);
	    continue;
	}
	
	if (strcmp(strPos, "NH") == 0) {
	    strtok(NULL, " ");
	    char *tok = strtok(NULL, " ");

	    nextHop = inetAddrToInt(tok);
	    nextHopFound = true;
	    /* BUG?  the original code by INI students was
	     * addrMap->insertItem (dest); I've changed to nextHop -- yhchu
	     */
	    //addrMap->insertItem(nextHop);
	    addrMap->insertItem(dest);
	    
	    // fprintf(stderr, "NH = %s ", tok);
	    continue;
	}

	if (strcmp(strPos, "numChildren") == 0) {
	    strtok(NULL, " ");
	    char *tok = strtok(NULL, " ");

	    this->numChild = atoi(tok);
	    numChildrenFound = true;

	    // fprintf(stderr, "numChildren = %d ", this->numChild);
	    continue;
	}

	if (strcmp(strPos, "DeadFlg") == 0) {
	    strtok(NULL, " ");
	    char *tok = strtok(NULL, " ");

	    int DeadFlg = atoi(tok);
	    dead = (DeadFlg?true:false);
	    deadFound = true;

	    // fprintf(stderr, "DeadFlg = %d ", DeadFlg);
	    continue;
	}
    }

    if (! (destFound && nextHopFound && costFound && deadFound 
	   && numChildrenFound)) {
	fprintf(stderr, "%s\n", str);
	assert("VRT not properly parsed" == NULL);
    }
    
    int destIndex = addrMap->getIndex(dest);
    newVRTable->setEntryByIndex(destIndex, dest, nextHop, cost, dead);
  }
  else if (VRTStart && (pos = strstr(str, "Children")) != NULL) {
    // require numChild info 
    char* strPos = strtok(str, " ");
    strPos = strtok (NULL, " ");
    int index = addrMap->getIndex(this->forwardSource);
    SpanningTreeTableEntry* entry = new SpanningTreeTableEntry(index, this->vrtSize);
    int childID;
    int childAddr;
    for (int i=0; i < this->numChild; i++) {
      strPos = strtok (NULL, " ");
      if (strPos[strlen(strPos) - 1] == '\n')
	strPos[strlen(strPos) - 1] = '\0';
      childAddr = inetAddrToInt(strPos);
      addrMap->insertItem(childAddr);
      childID = addrMap->getIndex(childAddr);
      assert (childID != -1);
      entry->markChild(childID);
    }
    newSpanningTreeTable->insertEntryToTable(index, entry);
    this->numChild = -1;
   
  }
  else if (VRTStart && (pos = strstr(str, "VRT End")) != NULL) {

    cout << " ******* Host Count " << addrMap->getSize() << endl;
    bool* changeVector = new bool[addrMap->getSize()];
    int numChanges;
    if (curVRTable == NULL) { // new table
      for (int i = 0; i < addrMap->getSize(); i++) 
	changeVector[i] = true;
      numChanges = addrMap->getSize(); // all
    }
    else {
      numChanges = curVRTable->compareTable(newVRTable, changeVector);
    }

    bool* streeChangeVector = new bool[addrMap->getSize()];
    int numStreeChange;
    if (curSpanningTreeTable == NULL) { // new table
      for (int i = 0; i < addrMap->getSize(); i++)
	streeChangeVector[i] = true;
      numStreeChange = addrMap->getSize(); // all
    }else {
      numStreeChange = curSpanningTreeTable->compareTable(newSpanningTreeTable, streeChangeVector);
    }


    // send changes out from newVRTable
    cout << "********* Number of VRT changes " << numChanges << endl;
    VRTableEntry* entryToSend = new VRTableEntry[addrMap->getSize()];
    cout<<"VRT Size: "<<addrMap->getSize()<<endl;
    int currCount = 0;
    for (int i = 0; i < addrMap->getSize(); i++) {
      if (changeVector[i]) {
	// send packet out, 
	entryToSend[currCount] = newVRTable->getEntryByIndex(i);
	// print out to screen
	cout << "--- SEND: time: " <<  vrtTime  << " currenthost " << currentHost;
	cout << " dest: " << entryToSend[currCount].dest << " nextHop " << entryToSend[currCount].nextHop;
	cout << " cost " << entryToSend[currCount].cost << " deadFlag " << entryToSend[currCount].deadFlag;
	cout << endl;
	currCount ++;

      }
    }

    // ahcheng - 0906
    // even though there is no update to VRT table, we still send out
    // some indication that there is a dump necessary on the Java side
    Packet packet;
    createPacket(vrtTime, currentHost, vrtSize, entryToSend, currCount, packet);
    sendBuffer->enqueue(packet);


    cout << "********* Number of SpanningTree changes " << numStreeChange << endl;
    cout<<"Spanning Tree Size: "<< addrMap->getSize()<<endl;

    currCount = 0;
    SpanningTreeTablePacketEntry* packetEntry = new SpanningTreeTablePacketEntry[addrMap->getSize()];

    SpanningTreeTableEntry* entry;
    cout << "--- SEND: time: " <<  vrtTime  << " currenthost " << currentHost << endl;
    for (int i = 0; i < addrMap->getSize(); i++) {
      if (streeChangeVector[i]) {
	// print out to screen
	cout << " ---- SEND: forwarding source " << addrMap->getElementAtIndex(i);

	packetEntry[currCount].forwardHost = addrMap->getElementAtIndex(i);

	entry = newSpanningTreeTable->getEntryByIndex(i);

	packetEntry[currCount].numChildren = entry->numChildren();
	packetEntry[currCount].children = new int[entry->numChildren()];

	int childCount = 0;

	cout << " " << entry->numChildren() << " childres are : ";
	for (int j = 0; j < entry->getChildArraySize(); j++) {
	  if(entry->isChild(j)) {
	    cout << addrMap->getElementAtIndex(j) << " ";
	    packetEntry[currCount].children[childCount] = addrMap->getElementAtIndex(j);
	    childCount ++;
	  }
	}

	currCount ++;

	cout << endl;
      }
    }

    if (numStreeChange > 0 || numChanges > 0) {
      Packet packet2;
      createPacket(vrtTime, currentHost, vrtSize, packetEntry, currCount, packet2);
      sendBuffer->enqueue(packet2);
    }
      
    // clean up
    VRTStart = false;
    vrtTime = -1;
    vrtSize = -1;
    if (curVRTable != NULL)
      delete curVRTable;
    curVRTable = newVRTable;
    newVRTable = NULL;
    delete [] changeVector;
    delete[] entryToSend;
    
    if (curSpanningTreeTable != NULL) 
      delete curSpanningTreeTable;
    curSpanningTreeTable = newSpanningTreeTable;
    newSpanningTreeTable = NULL;
    delete [] streeChangeVector;

  }  
}

int Parser::inetAddrToInt(char* host) {
  hostent* node = gethostbyname(host);
  
  if (node == NULL)
    return -1;

  sockaddr_in addr;
  bzero((char*)&addr, sizeof(sockaddr_in));
  memcpy((char*)&(addr.sin_addr.s_addr), node->h_addr, node->h_length);
  return (int)ntohl(addr.sin_addr.s_addr);

}

void Parser::createPacket(double time, int curhost, int vrtSize, SpanningTreeTablePacketEntry entry[], int size, 
			  Packet& packet) {
  char *data = NULL;
  int len = sizeof(double) + sizeof(int) + 3;
  for (int i = 0; i < size; i++)
    len += sizeof(int) + sizeof(int) + entry[i].numChildren * sizeof(int);

  char vrt = (char)vrtSize;

#if (defined(LINUX) || defined(FreeBSD))
  time = changeDoubleEndian(time);
#endif

  char tableSize = (char)size;
  curhost = htonl(curhost);

  data = new char[len];
  memcpy((char*)data, (char*)&SPANNINGTREE, sizeof(char));
  memcpy((char*)(data + sizeof(char)),(char*)&time, sizeof(double));
  memcpy((char*)(data + sizeof(char) + sizeof(double)), (char*)&curhost, sizeof(int));
  memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int)),
	 (char*)&tableSize, sizeof(char));
  memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int) + sizeof(char)),
	 (char*)&vrt, sizeof(char));

  int startPos = sizeof(char) + sizeof(double) + sizeof(int) + sizeof(char) + sizeof(char);

  for (int i = 0; i < size; i++) {
    int forward = htonl(entry[i].forwardHost);
    char numchild = (char)entry[i].numChildren;

    memcpy((char*)(data + startPos), (char*)&forward, sizeof(int));
    memcpy((char*)(data + startPos + sizeof(int)), (char*)&numchild, sizeof(char));
    
    int childStartPos = startPos + sizeof(int) + sizeof(char);
    for (int j = 0; j < entry[i].numChildren; j++) {
      int child = htonl(entry[i].children[j]);
      memcpy((char*)(data + childStartPos + j * sizeof(int)), (char*)&child, sizeof(int));
    }
    
    startPos += sizeof(int) + sizeof(char) + entry[i].numChildren * sizeof(int);
  }
  
  if (len == 0)
    return;
  
  int seq = table->getSeqNum();
  createDataPacket(packet, seq, data, len);
  table->incrementSeqNum();

  delete[] data;

}

void Parser::createPacket(double time, int curhost, int vrtSize, VRTableEntry entry[], int size, Packet& packet) {
  const int VRTableEntrySize = sizeof(int) * 3 + 1;
  const char DEAD = 1;
  const char ALIVE = 0;

  char* data = NULL;
  int len = sizeof(double) + sizeof(int) + size * VRTableEntrySize + 3;
  char tableSize = (int)size;

  char vrt = (char)vrtSize;

#if (defined(LINUX) || defined(FreeBSD))
  time = changeDoubleEndian(time);
#endif
  
  curhost = htonl(curhost);
  
  data = new char[len];
  memcpy((char*)data, (char*)&VRTENTRY, sizeof(char));
  memcpy((char*)(data + sizeof(char)), (char*)&time, sizeof(double));
  memcpy((char*)(data + sizeof(char) + sizeof(double)), (char*)&curhost, sizeof(int));
  memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int)),
	 (char*)&tableSize, sizeof(char));
  memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int) + sizeof(char)),
	 (char*)&vrt, sizeof(char));

  for (int i = 0; i < size; i++) {
    int dest = htonl(entry[i].dest);
    int nexthop = htonl(entry[i].nextHop);
    int cost = htonl(entry[i].cost);

    memcpy((char*)(data + sizeof(char) * 3 + sizeof(double) + sizeof(int) + i * VRTableEntrySize),
	   (char*)&dest,
	   sizeof(int));
    memcpy((char*)(data + sizeof(char) * 3 + sizeof(double) + sizeof(int) + i * VRTableEntrySize + 
		   sizeof(int)),
	   (char*)&nexthop,
	   sizeof(int));
    memcpy((char*)(data + sizeof(char) * 3 + sizeof(double) + sizeof(int) + i * VRTableEntrySize + 
		   sizeof(int) +
		   sizeof(int)),
	   (char*)&cost,
	   sizeof(int));
    if (!entry[i].deadFlag) 
      memcpy((char*)(data + sizeof(char) * 3 + sizeof(double) + sizeof(int) + i * VRTableEntrySize + 
		     sizeof(int) +
		     sizeof(int) + sizeof(int)),
	     (char*)&ALIVE,
	     sizeof(char));
    else
      memcpy((char*)(data + sizeof(char) * 3 + sizeof(double) + sizeof(int) + i * VRTableEntrySize + 
		     sizeof(int) +
		     sizeof(int) + sizeof(int)),
	     (char*)&DEAD,
	     sizeof(char));
  }

  if (len == 0)
    return;
  
  int seq = table->getSeqNum();
  createDataPacket(packet, seq, data, len);
  table->incrementSeqNum();

  delete[] data;

}

void Parser::createPacket(double time, int curhost, int targethost, int delay, char type,
			  Packet& packet) {

  char* data = NULL;
  int len = 0;

  curhost = htonl(curhost);

#if (defined(LINUX) || defined(FreeBSD))
  time = changeDoubleEndian(time);
#endif

  switch (type) {
  case JOIN:
    {
      len = sizeof(double) + sizeof(int) + 1;
      data = new char[len];
      memcpy((char*)data, (char*)&type, sizeof(char));
      memcpy((char*)(data + sizeof(char)),
	     (char*)&time, sizeof(double));
      memcpy((char*)(data + sizeof(char) + sizeof(double)),
	     (char*)&curhost, sizeof(int));

    }
    break;
  case DEAD:
  case ADD_NBR_RESPONSE:
  case INTENT_TO_CANCEL:
  case CANCEL_NEIGHBOR:
    {
      len = sizeof(double) + sizeof(int) * 2 + 1;
      data = new char[len];
      targethost = htonl(targethost);
      memcpy((char*)data, (char*)&type, sizeof(char));
      memcpy((char*)(data + sizeof(char)),
	     (char*)&time, sizeof(double));
      memcpy((char*)(data + sizeof(char) + sizeof(double)),
	     (char*)&curhost, sizeof(int));
      memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int)),
	     (char*)&targethost, sizeof(int));

    }
    break;
  case DELAY:
    {
      len = sizeof(double) + sizeof(int) * 3 + 1;
      data = new char[len];
      targethost = htonl(targethost);
      delay = htonl(delay);
      memcpy((char*)data, (char*)&type, sizeof(char));
      memcpy((char*)(data + sizeof(char)),
	     (char*)&time, sizeof(double));
      memcpy((char*)(data + sizeof(char) + sizeof(double)),
	     (char*)&curhost, sizeof(int));
      memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int)),
	     (char*)&targethost, sizeof(int));   
      memcpy((char*)(data + sizeof(char) + sizeof(double) + sizeof(int) + sizeof(int)),
	     (char*)&delay, sizeof(int));
    }
    break;
  }

  if (len == 0)
    return;

  int seq = table->getSeqNum();
  createDataPacket(packet, seq, data, len);
  table->incrementSeqNum();

  delete[] data;

}


double Parser::changeDoubleEndian(double orig) {
  double newVal;
  char buf1[sizeof(double)];
  char buf2[sizeof(double)];

  memcpy((char*)buf1, (char*)&orig, sizeof(double));

  for (unsigned int i = 0; i < sizeof(double); i++)
    buf2[i] = buf1[sizeof(double) - 1 -i];

  memcpy((char*)&newVal, (char*)buf2, sizeof(double));
  
  return newVal;

}







