#ifndef PACKET_H_
#define PACKET_H_

#include <string.h>
#include <strings.h>
#include <iostream.h>

struct Packet {
  char* data;
  int packetSize;

  Packet() {
    data = NULL;
    packetSize = 0;
  }

  ~Packet() {
    clear();

  }

  void clear() {
    delete[] data;
    data = NULL;
    packetSize = 0;
  }

  void setSize(int size) {
    packetSize = size;
    data = new char[size];
    bzero(data, size);
  }

  Packet& operator+=(const Packet& src) {
    this->data = new char[src.packetSize];
    this->packetSize = src.packetSize;
    memcpy((char*)(this->data), (char*)(src.data), src.packetSize);

    return *this;
  }

  void copy(Packet& target) {
    target.data = new char[packetSize];
    target.packetSize = packetSize;
    memcpy((char*)(target.data), (char*)data, packetSize);
  }


};


#endif
