#ifndef NETWORK_H_
#define NETWORK_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <strings.h>

#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <pthread.h>

#include <netdb.h>

#include <netinet/in.h>


#include "TransmissionTable.h"
#include "BufferQueue.h"

#include <iostream.h>

extern sem_t monitorLock;
extern int vrtInterval;

int createSocketID();

void* network_sendfunc(char* args);

void* network_recvfunc(char* args);

void initializeNetworkComponents(int sockfd, char* monitor, int port,
				 BufferQueue *sendBuffer,
				 TransmissionTable* t);

void createAckPacket(Packet& packet, int recvSeq);

void createDataPacket(Packet& packet, int seqNum, char* data, int len);

void createInitPacket(Packet& packet);

void createTerminatePacket(Packet& packet);

#endif
