#ifndef BUFFERQUEUE_H_
#define BUFFERQUEUE_H_

#include <semaphore.h>
#include <stdlib.h>

#include "Packet.h"
#include "TransmissionTable.h"

class BufferQueue {

 public:
  BufferQueue(short size);
  ~BufferQueue();
  int enqueue(Packet &packet);
  void checkIfExist();
  void getHead(Packet &packet);
  void removeHead();
  
 private:
  short increment(short value);

  Packet* buffer;
  short maxSize;
  short currSize;
  short headIndex;
  short tailIndex;

  sem_t bufferLock;
  sem_t emptyLock;

};

#endif
