
#include "BufferQueue.h"

#include <iostream.h>

BufferQueue::BufferQueue(short size) {
  buffer = new Packet[size];
  maxSize = size;
  currSize = 0;
  headIndex = 0;
  tailIndex = 0;

  sem_init(&bufferLock, 0, 1);
  sem_init(&emptyLock, 0, 0);

}

BufferQueue::~BufferQueue() {
  delete[] buffer;
  buffer = NULL;
}

int BufferQueue::enqueue(Packet &packet) {
  if (currSize == maxSize) {
    return -1;
  }

  sem_wait(&bufferLock);

  packet.copy(buffer[tailIndex]);
  tailIndex = increment(tailIndex);
  currSize ++;

  sem_post(&emptyLock);
  sem_post(&bufferLock);

  return 0;

}


void BufferQueue::checkIfExist() {
  sem_wait(&emptyLock);

}


void BufferQueue::getHead(Packet &packet) {

  sem_wait(&bufferLock);

  buffer[headIndex].copy(packet);

  sem_post(&bufferLock);

}

void BufferQueue::removeHead() {
  sem_wait(&bufferLock);
  headIndex = increment(headIndex);
  currSize --;
  sem_post(&bufferLock);
}

short BufferQueue::increment(short value) {
  return (value + 1) % maxSize;
}
