#include "AddrMap.h"

AddrMap::AddrMap(int initSize, int resize) {
  map = new int[initSize];
  arraySize = initSize;
  count = 0;
  rf = resize;
}

AddrMap::~AddrMap() {
  delete [] map;
}
int AddrMap::getElementCount() {
  return count;
}

// only insert when no duplicate exist
void AddrMap::insertItem(int item) {
  int *newmap;
  if (getIndex(item) != -1) // item already exist
    return;
  if (count < arraySize) {
    map[count] = item;
    count++;
  } else { // resize the array
    newmap = new int[arraySize+rf];
    for (int i = 0; i < arraySize; i++) {
      newmap[i] = map[i];
    }
    arraySize += rf;
    newmap[count] = item;
    count++;
    // delete old map
    delete [] map;
    map = newmap;
  }
}

// return -1 if item is not in the array
int AddrMap::getIndex(int item) {
  for (int i=0; i < count; i++) {
    if (item == map[i])
      return i;
  }
  return -1; // nothing found
}

int AddrMap::getSize() {
  return count;
}

int AddrMap::getElementAtIndex(int index) {
  return map[index];
}
